<?php

include_once 'db.php';


header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);


$estimate_id = $data['estid'] ?? ''; 

if (empty($estimate_id)) {
    echo json_encode(['error' => 'estimate ID is required']);
    exit();
}


$estimateDataQuery  = "SELECT * FROM estimate_data  WHERE estimate_id ='$estimate_id' and Delete_status=0";
    $estimateDataResult = mysqli_query($conn, $estimateDataQuery);


    if (!$estimateDataResult) {
        echo json_encode(['error' => 'Failed to fetch order data: ' . mysqli_error($conn)]);
        exit();
    }
    
    $orders = [];
    $taxValues = [];

while ($row = mysqli_fetch_assoc($estimateDataResult)) {

    $productid = $row['Product_id'];

    $productQuery = "SELECT Product_id, Product_name FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';

    $mrp = $row['MRP'];
    $price = $row['Selling_price'];  
    $discount = $row ['discount'];
    $discountpercentage = $row['Discount_percentage'];
    $qty = $row['qty'];
    $amount = $row['Product_total'];
    $taxvalue = $row['Tax'];
    $taxpercentage = $row['Tax_percentage'];
    $salepricetax = $row['salepricetax'];

    $orders[] = [

        'productid' => $productid,
        'productname' => $productname,
        'mrp' => $mrp,
        'price' => $price,  
        'discountvalue' => $discount,
        'discountpercentage' => $discountpercentage,
        'qty' => $qty,
        'amount' => $amount,
        'taxvalue' => $taxvalue,
        'taxpercentage' => $taxpercentage,
        'sale_price_tax' => $salepricetax

    ];

    $taxValues[] = $row['Tax'];
}



// Output the results as HTML rows
$ordersHtml = '';
foreach ($orders as $order) {
    $ordersHtml .="<tr class='align-items-top'>

        <td class='align-items-top productname'>

            {$order['productname']}

            <input type='hidden' id='productid' class='productid' name='productid[]' value='{$order['productid']}'>
<input type='hidden' id='salepricetax' class='salepricetax' name='salepricetax[]' value='{$order['sale_price_tax']}'>
        </td>

        <td>

            <button type='button' name='remove' id='removeicon' class='' style='color:blue; font-weight:300; top: -100px; border:none;'>

                <i class='dw dw-cancel'></i>

            </button>

        </td>

        <td></td>

        <td class='align-items-top'>

            <input type='text' name='mrp[]' class='invTable mrp' value='{$order['mrp']}'>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable price' name='price[]' value='{$order['price']}'>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable discountvalue' name='discountvalue[]' value='{$order['discountvalue']}'>

            <br>

            <div style='position: relative; display: inline-block;'>

                <input class='invTable discountpercentage' name='discountpercentage[]' value='{$order['discountpercentage']}' style='margin-top:5px;' type='text'>

                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>

            </div>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable qty' name='qty[]' value='{$order['qty']}'>

        </td>

        <td class='align-items-top'>

            <div style='position: relative; display: inline-block;'>

                <input type='text' name='taxpercentage[]' class='invTable taxpercentage' value='{$order['taxpercentage']}' style='padding-right: 20px; box-sizing: border-box;'>

                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>

            </div>

            <br>

            <span class='taxvalue'>₹" . number_format($order['taxvalue'], 2) . "</span>

        </td>

        <td></td>

        <td class='align-items-top amountspan'>" . number_format($order['amount'], 2) . "</td>

    </tr>";

}



echo json_encode(['ordersHtml' => $ordersHtml, 'taxValues' => $taxValues]);


// Close the database connection
mysqli_close($conn);
?>