<?php
include_once 'db.php';
session_start();

header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

// Extract the estimate ID from the decoded data
$estimateid = $data['estimate_id'] ?? ''; 

if (empty($estimateid)) {
    echo json_encode(['error' => 'estimate ID is required']);
    exit();
}

// Query to fetch estimate data
$estimateDataQuery = "SELECT * FROM estimate_data WHERE estimate_id = '$estimateid' AND Delete_status = 0";
$estimateDataResult = mysqli_query($conn, $estimateDataQuery);

if (!$estimateDataResult) {
    echo json_encode(['error' => 'Failed to fetch estimate data: ' . mysqli_error($conn)]);
    exit();
}

$estimates = [];

while ($row = mysqli_fetch_assoc($estimateDataResult)) {
    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name,Product_image FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';
    $productimage = $product['Product_image']?? '';

    // Add estimate data to the array
    $estimates[] = [
        'productid' => $productid,
        'productname' => $productname,
        'productimage' => $productimage,
        'mrp' => $row['MRP'],
        'saleprice' => $row['Selling_price'],
        'discountvalue' => $row['discount'],
        'discountpercentage' => $row['Discount_percentage'],
        'qty' => $row['qty'],
        'amount' => $row['Product_total'],
        'taxvalue' => $row['Tax'],
        'taxpercentage' => $row['Tax_percentage'],
        'salepricetax' => $row['salepricetax']
    ];
}

// Store the fetched data in the session
$_SESSION['estimate_data'] = $estimates;

echo json_encode(['status' => 'success', 'data' => $estimates]);

// Close the database connection
mysqli_close($conn);
?>
