<?php
include_once 'db.php';
session_start();

header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

// Extract the invoice ID from the decoded data
$invoiceid = $data['invoice_id'] ?? ''; 

if (empty($invoiceid)) {
    echo json_encode(['error' => 'Invoice ID is required']);
    exit();
}

// Query to fetch invoice data
$invoiceDataQuery = "SELECT * FROM invoice_data WHERE invoice_id = '$invoiceid' AND Delete_status = 0";
$invoiceDataResult = mysqli_query($conn, $invoiceDataQuery);

if (!$invoiceDataResult) {
    echo json_encode(['error' => 'Failed to fetch invoice data: ' . mysqli_error($conn)]);
    exit();
}

$invoices = [];

while ($row = mysqli_fetch_assoc($invoiceDataResult)) {
    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name,Product_image FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';
    $productimage = $product['Product_image']?? '';

    // Add invoice data to the array
    $invoices[] = [
        'productid' => $productid,
        'productname' => $productname,
        'productimage' => $productimage,
        'mrp' => $row['MRP'],
        'saleprice' => $row['Selling_price'],
        'discountvalue' => $row['discount'],
        'discountpercentage' => $row['Discount_percentage'],
        'qty' => $row['qty'],
        'amount' => $row['Product_total'],
        'taxvalue' => $row['Tax'],
        'taxpercentage' => $row['Tax_percentage'],
        'salepricetax' => $row['salepricetax']
    ];
}

// Store the fetched data in the session
$_SESSION['invoice_data'] = $invoices;

echo json_encode(['status' => 'success', 'data' => $invoices]);

// Close the database connection
mysqli_close($conn);
?>
