<?php 
include_once 'db.php';

header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

// Extract the order ID from the decoded data
$orderid = $data['order_id'] ?? ''; 

if (empty($orderid)) {
    echo json_encode(['error' => 'Order ID is required']);
    exit();
}

// Query to fetch order data
$orderDataQuery = "SELECT * FROM order_data WHERE Order_id = '$orderid' AND Delete_status = 0";
$orderDataResult = mysqli_query($conn, $orderDataQuery);

if (!$orderDataResult) {
    echo json_encode(['error' => 'Failed to fetch order data: ' . mysqli_error($conn)]);
    exit();
}

$orders = [];
$taxValues = [];

while ($row = mysqli_fetch_assoc($orderDataResult)) {
    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';

    // Add order data to the array
    $orders[] = [
        'productid' => $productid,
        'productname' => $productname,
        'mrp' => $row['MRP'],
        'saleprice' => $row['Selling_price'],
        'price' => '',
        'discountvalue' => $row['discount'],
        'discountpercentage' => $row['Discount_percentage'],
        'qty' => $row['qty'],
        'amount' => $row['Product_total'],
        'taxvalue' => $row['Tax'],
        'taxpercentage' => $row['Tax_percentage'],
        'salepricetax' => $row['salepricetax']
    ];

    $taxValues[] = $row['Tax'];
}


$ordersHtml = '';
foreach ($orders as $order) {
    $ordersHtml .= "<tr class='align-items-top'>
        <td class='align-items-top productname'>
            {$order['productname']}
            <input type='hidden' class='productid' name='productid[]' value='{$order['productid']}'>
            <input type='hidden' id='salepricetax' class='salepricetax' name='salepricetax[]' value='{$order['salepricetax']}'>
        </td>
        <td>
            <button type='button' name='remove' class='' style='color:blue; font-weight:300; border:none;'>
                <i class='dw dw-cancel'></i>
            </button>
        </td>
        <td></td>
        <td class='align-items-top'>
            <input type='text' name='mrp[]' class='invTable mrp' value='{$order['mrp']}'>
        </td>
        <td class='align-items-top'>
            <input type='text' name='price[]' class='invTable price' value='{$order['price']}'>
        </td>
        <td class='align-items-top'>
            <input type='text' name='discountvalue[]' class='invTable discountvalue' value='{$order['discountvalue']}'>
            <div style='position: relative; display: inline-block; margin-top: 5px;'>
                <input type='text' name='discountpercentage[]' class='invTable discountpercentage' value='{$order['discountpercentage']}'>
                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>
            </div>
        </td>
        <td class='align-items-top'>
            <input type='text' name='qty[]' class='invTable qty' value='{$order['qty']}'>
        </td>
        <td class='align-items-top'>
            <div style='position: relative; display: inline-block;'>
                <input type='text' name='taxvalue1[]' class='invTable taxvalue' value='{$order['taxpercentage']}' style='padding-right: 20px;'>
                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>
            </div><br>
            <span class='taxvalue-display'>₹ {$order['taxvalue']}</span>
        </td>
        <td></td>
        <td class='align-items-top amountspan'>" . number_format($order['amount'], 2) . "</td>
    </tr>";
}

echo json_encode(['ordersHtml' => $ordersHtml, 'taxValues' => $taxValues]);


// Close the database connection
mysqli_close($conn);
?>
