<?php

// Set headers for JSON response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database connection
include_once 'db.php';

// Fetch the orderId parameter from the URL
$orderid = $_GET['orderId'] ?? '';

if (!$orderid) {
    echo json_encode([
        "status" => "error",
        "message" => "Order ID is required"
    ]);
    exit;
}

// Initialize variables
$pdfContents = [];
$taxvalue = 0;

// Fetch order details
$query = mysqli_query($conn, "SELECT * FROM orders WHERE Order_id = '$orderid'");

if (!$query) {
    echo json_encode([
        "status" => "error",
        "message" => "Database query failed: " . mysqli_error($conn)
    ]);
    exit;
}

$order = mysqli_fetch_array($query);

if (!$order) {
    echo json_encode([
        "status" => "error",
        "message" => "No invoice found for Order ID: " . $orderid
    ]);
    exit;
}

// Fetch customer details
$customerid = $order['user_id'];
$grandtotal = $order['Grand_total'];
$orderdate = $order['Created_date'];
$orderno = $order['order_no'];
$totalSavings = $order['Total_saving'];


$customerquery = mysqli_query($conn, "SELECT * FROM customer WHERE id='$customerid'");

if (!$customerquery) {
    echo json_encode([
        "status" => "error",
        "message" => "Customer query failed: " . mysqli_error($conn)
    ]);
    exit;
}

$customerfetch = mysqli_fetch_array($customerquery);

if (!$customerfetch) {
    echo json_encode([
        "status" => "error",
        "message" => "No customer found for ID: " . $customerid
    ]);
    exit;
}

$displayname = $customerfetch['displayname'];
$address = $customerfetch['address'];
$city = $customerfetch['city'];
$pincode = $customerfetch['pincode'];
$email = $customerfetch['email'];
$phoneno = $customerfetch['phoneno'];

// Fetch profile details for logo
$qs = "SELECT * FROM user_profile WHERE User_id= 4";
$results = mysqli_query($conn, $qs);

if (!$results) {
    echo json_encode([
        "status" => "error",
        "message" => "Profile query failed: " . mysqli_error($conn)
    ]);
    exit;
}

$rows = mysqli_fetch_array($results);

if (!$rows) {
    echo json_encode([
        "status" => "error",
        "message" => "No profile found."
    ]);
    exit;
}

$logopath = $rows['store_image'];
$store_name = $rows['store_name'];
$Email = $rows['Email'];
$street1 = $rows['Address'];
$street2 = $rows['street2'];
$City = $rows['City'];
$Pincode = $rows['Pincode'];
$phone = $rows['Phone'];

// Fetch order data
$queryorderData = "
    SELECT 
        o.Order_id,
        o.Product_id,
        o.Selling_price,
        o.Tax_percentage,
        o.Tax,
        o.Product_total,
        o.Discount_percentage,
        o.qty AS Qty,
        o.MRP,
        p.Product_name,
        p.Delete_status
    FROM 
        order_data o
    INNER JOIN 
        product p 
    ON 
        o.Product_id = p.Product_id
    WHERE 
        o.order_id = '$orderid' 
        AND p.Delete_status = 0 AND o.Delete_status=0";

$resultorderData = mysqli_query($conn, $queryorderData);

if (!$resultorderData) {
    echo json_encode([
        "status" => "error",
        "message" => "Order data query failed: " . mysqli_error($conn)
    ]);
    exit;
}
$qs1 = "SELECT * FROM invoicesetting WHERE id= 1";
$results1 = mysqli_query($conn, $qs1);

if (!$results1) {
    echo json_encode([
        "status" => "error",
        "message" => "Profile query failed: " . mysqli_error($conn)
    ]);
    exit;
}

$rows1 = mysqli_fetch_array($results1);

if (!$rows1) {
    echo json_encode([
        "status" => "error",
        "message" => "No profile settings found."
    ]);
    exit;
}
$note = $rows1['note'];
$terms = $rows1['terms'];
$qrcode = $rows1['qrcode'];

// Prepare invoice data array
$orderData = [];
while ($row = mysqli_fetch_assoc($resultorderData)) {
    $taxvalue += $row['Tax'];
    $orderData[] = [
        "order_id" => $row['Order_id'],
        "Product_id" => $row['Product_id'],
        "Product_name" => $row['Product_name'],
        "Selling_price" => $row['Selling_price'],
        "Tax_percentage" => $row['Tax_percentage'],
        "Tax" => $row['Tax'],
        "Qty" => $row['Qty'],
        "MRP" => $row['MRP'],
        "Discount_percentage" => $row['Discount_percentage'],
        "Product_total" => $row['Product_total']
    ];
}

// Combine profile data and invoice data
$response = [
    "status" => "success",
    "profile" => [
        "logopath" => $logopath,
        "store_name" => $store_name,
        "Email" => $Email,
        "street1" => $street1,
        "street2" => $street2,
        "City" => $City,
        "Pincode"=> $Pincode,
        "phone"=>$phone,
        "displayname" => $displayname,
        "address" => $address,
        "city" => $city,
        "pincode" => $pincode,
        "email" => $email,
        "phoneno" => $phoneno
    ],
    "order_data" => $orderData,
    "taxvalue" => $taxvalue,
    "grandtotal" => $grandtotal,
    "orderdate" => $orderdate,
    "orderno" => $orderno,
    "totalsavings" => $totalSavings,
    "note"=> $note,
    "terms" => $terms,
    "qrcode" => $qrcode
];

// Return JSON response
echo json_encode($response, JSON_PRETTY_PRINT);

?>
