<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if category is provided in the GET request
if (isset($_GET['category_id'])) {
    // Sanitize the category input
    $category = $conn->real_escape_string($_GET['category_id']);
    $sortBy = isset($_GET['sort']) ? $_GET['sort'] : 'Default';

    // Initialize the SQL query
    $sql = "SELECT * FROM product WHERE Delete_status = 0 AND subcategory = '$category'";

    // Add sorting based on the `sortBy` parameter
    switch ($sortBy) {
        case 'Order by Price':
            $sql .= " ORDER BY sales_price ASC"; // or DESC based on requirement
            break;
        case 'Order by Name':
            $sql .= " ORDER BY name ASC";
            break;
        case 'Order by Rating':
            $sql .= " ORDER BY rating DESC";
            break;
        default:
            // Default sorting (no order)
            $sql .= " ORDER BY Product_id DESC";
            break;
    }

    // Execute the query
    $result = $conn->query($sql);

    // Check if products are found
    if ($result && $result->num_rows > 0) {
        // Fetch all matching products
        $products = [];
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }
        // Return products as JSON
        echo json_encode(['status' => 'success', 'data' => $products]);
    } else {
        // No products found for the category
        echo json_encode(['status' => 'error', 'message' => 'No products found for the given category']);
    }
} else {
    // If category is not provided
    echo json_encode(['status' => 'error', 'message' => 'Category is required']);
}

$conn->close();
?>
