<?php
include("db.php"); // Include your database connection

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // Query to fetch categories with their respective subcategories
    $query = "
        SELECT 
            c.category_ID,
            c.name AS category_name,
            c.image AS category_image,
            c.gmccategorg,
            c.urlslug,
            c.seotitle,
            c.seodescription,
            c.Create_at,
            c.mode,
            c.Delete_status,
            sc.ID AS subcategory_id,
            sc.Subcategory_Name AS subcategory_name,
            sc.image AS subcategory_image,
    (
        SELECT 
            COUNT(*) 
        FROM 
            subcategory 
        WHERE 
            subcategory.Category_ID = c.category_ID 
            AND subcategory.Delete_status = 0
    ) AS subcategory_count
        FROM 
            categories AS c
        LEFT JOIN 
            subcategory AS sc 
        ON 
            c.category_ID = sc.Category_ID
        WHERE 
            c.Delete_status = 0 AND (sc.Delete_status = 0 OR sc.ID IS NULL)
        ORDER BY 
            c.position ASC , sc.ID DESC
    ";

    $result = $conn->query($query);

    if ($result && $result->num_rows > 0) {
        $categories = [];

        // Group categories and their subcategories
        while ($row = $result->fetch_assoc()) {
            $categoryId = $row['category_ID'];
            if (!isset($categories[$categoryId])) {
                // Initialize category
                $categories[$categoryId] = [
                    'category_ID' => $row['category_ID'],
                    'name' => $row['category_name'],
                    'image' => $row['category_image'],
                    'gmccategorg' => $row['gmccategorg'],
                    'urlslug' => $row['urlslug'],
                    'seotitle' => $row['seotitle'],
                    'seodescription' => $row['seodescription'],
                    'Create_at' => $row['Create_at'],
                    'mode' => $row['mode'],
                    'Delete_status' => $row['Delete_status'],
                    'subcategorycount'=>$row['subcategory_count'],
                    'subcategories' => [] // Initialize subcategories
                ];
            }

            // Add subcategory if it exists
            if (!empty($row['subcategory_id'])) {
                $categories[$categoryId]['subcategories'][] = [
                    'subcategory_id' => $row['subcategory_id'],
                    'subcategory_name' => $row['subcategory_name'],
                    'subcategory_image' => $row['subcategory_image']
                ];
            }
        }

        // Reset keys to provide a clean JSON response
        $categories = array_values($categories);

        // Return the categories as JSON
        echo json_encode(['status' => 'success', 'data' => $categories]);
    } else {
        // No categories found
        echo json_encode(['status' => 'error', 'message' => 'No categories found']);
    }
} else {
    // Invalid method
    echo json_encode([
        'status' => 'error',
        'message' => 'Only GET method is allowed.'
    ]);
}

$conn->close();
?>
