<?php
// Include your database connection
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Get POST parameters
$categoryid = $_POST['categoryid'] ?? '';
$productstatusid = $_POST['productstatusid'] ?? '';
$searchIconslist = trim($_POST['searchIcon'] ?? '');
$stockstatusid = $_POST['stockstatusid'] ?? '';
$searchIcons = strtolower($searchIconslist);
$sortby = $_POST['sortbyfiltrid'] ?? '';

// Base query
$sql = "SELECT Product_id, Product_name, SKU, Selling_price, MRP, qty, Product_image , Variant, mode
        FROM product 
        WHERE Delete_status = 0 AND Product_name != ''";

// Filter by stock status
if ($stockstatusid !== '') {
    if ($stockstatusid == '1') {
        $sql .= " AND qty <= 0";
    } elseif ($stockstatusid == '2') {
        $sql .= " AND qty > 0";
    }
}

// Filter by product status
if ($productstatusid !== '') {
    $sql .= " AND mode = '$productstatusid'";
}

// Filter by search term
if ($searchIcons !== '') {
    $sql .= " AND LOWER(Product_name) LIKE '%$searchIcons%'";
}

// Filter by category
if ($categoryid !== '') {
    $sql .= " AND category = '$categoryid'";
}

// Apply sorting
if ($sortby !== '') {
    if ($sortby == '1') {
        $sql .= " ORDER BY Selling_price DESC";
    } elseif ($sortby == '2') {
        $sql .= " ORDER BY Selling_price ASC";
    } elseif ($sortby == '3') {
        $sql .= " ORDER BY Product_name DESC";
    } elseif ($sortby == '4') {
        $sql .= " ORDER BY qty DESC";
    } elseif ($sortby == '5') {
        $sql .= " ORDER BY qty ASC";
    }
} else {
    $sql .= " ORDER BY Product_id DESC"; // Default sorting
}

// Execute the query
$result = $conn->query($sql);

// Prepare the response
if ($result && $result->num_rows > 0) {
    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = [
            'id' => $row['Product_id'],
            'productname' => $row['Product_name'],
            'sku' => $row['SKU'],
            'saleprice' => $row['Selling_price'],
            'mrp' => $row['MRP'],
            'qty' => $row['qty'] ?: '0', // Default to 0 if qty is empty
            'productimg' => $row['Product_image'],
            'Variant' => $row['Variant'],
            'mode' => $row['mode']
        ];
    }
    echo json_encode(['status' => 'success', 'data' => $products]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No products found']);
}
?>
