<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve testimonial_id from the query parameter
$testimonial_id = $_GET['testimonial_id'] ?? null; // You can pass the testimonial_id as a query parameter

// Check if testimonial_id is provided
if (!$testimonial_id) {
    echo json_encode(["status" => "error", "message" => "testimonial ID is required"]);
    exit;
}

// Sanitize testimonial_id to prevent SQL injection
$testimonial_id = mysqli_real_escape_string($conn, $testimonial_id);

// Query to fetch SEO data for the given testimonial_id
$query = "SELECT * FROM testimonial_seo WHERE Testimonial_id = '$testimonial_id' AND Delete_status = 0"; // Make sure the testimonial is not marked as deleted

$result = mysqli_query($conn, $query);

// Check if any result was returned
if (mysqli_num_rows($result) > 0) {
    $testimonialSeoData = mysqli_fetch_assoc($result);
    echo json_encode(["status" => "success", "data" => $testimonialSeoData]);
} else {
    echo json_encode(["status" => "error", "message" => "No SEO data found for the provided testimonial ID"]);
}
?>
