<?php
// db.php for database connection
include('db.php');

// Initialize the response array
$response = array();

// Check if the 'paymentid' parameter is provided in the URL
if (isset($_GET['paymentid'])) {
    // Sanitize and validate the 'paymentid'
    $payment_id = intval($_GET['paymentid']); // Convert to an integer
    if ($payment_id <= 0) { // Validate: Ensure it's a positive number
        $response = array("message" => "Invalid payment ID");
        echo json_encode($response);
        exit;
    }

    // Build the SQL query to fetch the payment details
    $query = "SELECT 
        p.Payment_type,
        c.displayname,
        p.Payment_amount,
        p.Payment_date,
        p.Reference_id
    FROM payment p
    LEFT JOIN customer c ON p.customer_id = c.id
    WHERE p.Payment_id = $payment_id AND p.delete_status = 0";

    // Execute the query
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        // Fetch the payment data as an associative array
        $response = mysqli_fetch_assoc($result);
    } else {
        // No payment found
        $response = array("message" => "Payment not found");
    }
} else {
    // 'paymentid' parameter not provided
    $response = array("message" => "Payment ID is required");
}

// Close the database connection
mysqli_close($conn);

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
