<?php
// Include the database connection file
include("db.php");

// Start the session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set content type to JSON
header('Content-Type: application/json');

// Check if the user is logged in by checking the session
if (isset($_SESSION['user_id'])) {
    $user_id = intval($_SESSION['user_id']); // Sanitize the user_id to prevent SQL injection

    // Directly execute the query without prepared statements
    $sql = "SELECT Name, store_image,Role FROM user_profile WHERE Delete_status = 0 AND User_id = '$user_id' LIMIT 1";
    $result = $conn->query($sql);

    // Check if user exists
    if ($result && $result->num_rows > 0) {
        $user = $result->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'User profile retrieved successfully',
            'data' => $user
        ]);
    } else {
        // If the user is not found in the user_profile table
        http_response_code(404); // Not Found
        echo json_encode(['status' => 'error', 'message' => 'User not found']);
    }
} else {
    // If the user is not logged in (session not set)
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
}

// Close the database connection
$conn->close();
?>
