<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Optionally, you can use query parameters to filter the data
$wishlist_id = $_GET['wishlist_id'] ?? null; // Get wishlist_id from query parameters

// If wishlist_id is provided, fetch a specific record
if ($wishlist_id) {
    $wishlist_id = intval($wishlist_id);
    $query = "SELECT * FROM wish_list WHERE wishlist_id = $wishlist_id";
} else {
    // Otherwise, fetch all records
    $query = "SELECT * FROM wish_list";
}

// Execute the query
$result = mysqli_query($conn, $query);

// Check if any rows are returned
if (mysqli_num_rows($result) > 0) {
    // Fetch the results as an associative array
    $wish_list_items = mysqli_fetch_all($result, MYSQLI_ASSOC);
    echo json_encode(["status" => "success", "data" => $wish_list_items]);
} else {
    echo json_encode(["status" => "error", "message" => "No records found"]);
}
?>
