<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Optionally, you can use query parameters to filter the data
$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : null;

// If product_id is provided, fetch specific records
if ($product_id) {
    $query = "SELECT w.customer_id, c.displayname AS customer_name ,
                c.phoneno
              FROM wish_list w 
              JOIN customer c ON w.customer_id = c.id
              WHERE w.product_id = $product_id";
} else {
    // Otherwise, fetch all records
    $query = "SELECT w.customer_id, c.displayname AS customer_name, w.product_id
              FROM wish_list w
              JOIN customer c ON w.customer_id = c.id";
}

// Execute the query
$result = mysqli_query($conn, $query);

// Check if any rows are returned
if (mysqli_num_rows($result) > 0) {
    // Fetch the results as an associative array
    $wish_list_items = mysqli_fetch_all($result, MYSQLI_ASSOC);
    echo json_encode(["status" => "success", "data" => $wish_list_items]);
} else {
    echo json_encode(["status" => "error", "message" => "No records found"]);
}

// Close the database connection
mysqli_close($conn);
?>
