<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Optionally, you can use query parameters to filter the data
$customer_id = $_GET['customer_id'] ?? null; // Get customer_id from query parameters

if ($customer_id) {
    $customer_id = intval($customer_id);
    $query = "SELECT w.product_name, w.product_id, p.Product_image 
              FROM wish_list w 
              LEFT JOIN product p ON w.product_id = p.Product_id 
              WHERE w.customer_id = $customer_id";

    // Execute the query
    $result = mysqli_query($conn, $query);

    // Check if any rows are returned
    if ($result && mysqli_num_rows($result) > 0) {
        $wish_list_items = mysqli_fetch_all($result, MYSQLI_ASSOC);
        echo json_encode(["status" => "success", "data" => $wish_list_items]);
    } else {
        echo json_encode(["status" => "error", "message" => "No records found"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Customer ID is required"]);
}
?>
