<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Fetch grouped records by product_id
$query = "SELECT w.product_id, w.product_name, w.customer_id, c.displayname, c.phoneno ,p.Product_image
          FROM wish_list w
          LEFT JOIN product p ON p.Product_id = w.product_id
          LEFT JOIN customer c ON c.id = w.customer_id
          ORDER BY w.product_id";

$result = mysqli_query($conn, $query);

// Initialize an empty array for grouped results
$grouped_wishlist = [];

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $product_id = $row['product_id'];

        // If product_id is not in the grouped array, initialize it
        if (!isset($grouped_wishlist[$product_id])) {
            $grouped_wishlist[$product_id] = [
                "product_id" => $row['product_id'],
                "product_image" => $row['Product_image'],
                "product_name" => $row['product_name'],
                "customer_count" => 0,
                "wishlist_count" => 0,
                "customer_ids" => [] // Store customer IDs in an array
            ];
        }

        // Add customer_id to the array
        $grouped_wishlist[$product_id]["customer_ids"][] = $row['customer_id'];
        
        // Update counts
        $grouped_wishlist[$product_id]["customer_count"] = count(array_unique($grouped_wishlist[$product_id]["customer_ids"]));
        $grouped_wishlist[$product_id]["wishlist_count"]++;
    }

    // Convert grouped results to a simple array
    $output = array_values($grouped_wishlist);

    echo json_encode(["status" => "success", "data" => $output]);
} else {
    echo json_encode(["status" => "error", "message" => "No records found"]);
}
?>
