<?php
header("Content-Type: application/json");

require 'db.php'; // Ensure this connects correctly to your database

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Fetch the latest utmid from the customer table
$result = mysqli_query($conn, "SELECT utmid FROM customer ORDER BY id DESC LIMIT 1");
if ($result) {
    $row = mysqli_fetch_assoc($result);
    if ($row && isset($row['utmid'])) {
        // Extract the numeric part of the utmid and increment it
        $lastUtmId = $row['utmid'];
        $num = intval(substr($lastUtmId, 4)) + 1; // Extract the number after "UTM-" and increment
        $utmid = "UTM-" . str_pad($num, 4, '0', STR_PAD_LEFT); // Format as UTM-0021
    } else {
        // If no records exist, start with UTM-0001
        $utmid = "UTM-0001";
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to fetch latest utmid", "error_detail" => mysqli_error($conn)]);
    exit;
}

// Generate a guest username (e.g., guest0001)
$result = mysqli_query($conn, "SELECT id FROM customer ORDER BY id DESC LIMIT 1");
if ($result) {
    $row = mysqli_fetch_assoc($result);
    $lastId = $row ? intval($row['id']) + 1 : 1; // Get the last ID and increment
    $guestUsername = "guest" . str_pad($lastId, 4, '0', STR_PAD_LEFT); // Format as guest0001
} else {
    echo json_encode(["status" => "error", "message" => "Failed to generate guest username", "error_detail" => mysqli_error($conn)]);
    exit;
}

// Insert the guest customer with the generated guest username and utmid
$sql_customer = "INSERT INTO customer (customertype, displayname, utmid) VALUES ('1', '$guestUsername', '$utmid')";

if (mysqli_query($conn, $sql_customer)) {
    $customer_id = mysqli_insert_id($conn); // Retrieve the last inserted ID
    echo json_encode(["status" => "success", "message" => "Guest customer created successfully", "guest_username" => $guestUsername,"customer_id" =>$customer_id, "utmid" => $utmid]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert guest customer", "error_detail" => mysqli_error($conn)]);
}

mysqli_close($conn);
?>