<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve and validate input data
$byname = $_POST['byname'] ?? null;
$title = $_POST['title'] ?? null;
$description = $_POST['description'] ?? null;
$position = $_POST['position'] ?? null;
$active = $_POST['active'] ?? 1; // Default value is 1 (active)

if (!$byname || !$title || !$description || !$position) {
    echo json_encode(["status" => "error", "message" => "All fields are required"]);
    exit;
}

// Initialize the file upload directory
$imageDir = 'images/testimonial/';
$imagePath = null;

// Handle the image upload
if (!empty($_FILES['image']['name'])) {
    $imagePath = $imageDir . basename($_FILES['image']['name']);
    if (!move_uploaded_file($_FILES['image']['tmp_name'], $imagePath)) {
        echo json_encode(["status" => "error", "message" => "Failed to upload image"]);
        exit;
    }
}

// Insert the data into the testimonial table
$insertQuery = "
    INSERT INTO testimonial (byname, Title, Description, Image, position, active, Delete_status) 
    VALUES (
        '" . mysqli_real_escape_string($conn, $byname) . "',
        '" . mysqli_real_escape_string($conn, $title) . "',
        '" . mysqli_real_escape_string($conn, $description) . "',
        '" . mysqli_real_escape_string($conn, $imagePath) . "',
        '" . intval($position) . "',
        '" . intval($active) . "',
        0
    )
";

if (mysqli_query($conn, $insertQuery)) {
    echo json_encode(["status" => "success", "message" => "Testimonial added successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to add testimonial"]);
}
?>
