<?php
// Start the session
session_start();

// Include the database connection file
include("db.php");

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Check if the `store_image` file is uploaded
    if (!isset($_FILES['store_image']) || $_FILES['store_image']['error'] != 0) {
        echo json_encode(['status' => 'error', 'message' => 'Image upload is required']);
        exit();
    }

    // Read other POST data
    $rawData = $_POST;

    // Validate if required fields are present
    $requiredFields = ['name', 'email', 'phone', 'username', 'password', 'role', 'address', 'city', 'state', 'pincode'];

    foreach ($requiredFields as $field) {
        if (empty($rawData[$field])) {
            echo json_encode(['status' => 'error', 'message' => "$field is required"]);
            exit();
        }
    }

    // Sanitize and assign input data to variables
    $name = mysqli_real_escape_string($conn, $rawData['name']);
    $email = mysqli_real_escape_string($conn, $rawData['email']);
    $phone = mysqli_real_escape_string($conn, $rawData['phone']);
    $username = mysqli_real_escape_string($conn, $rawData['username']);
    $password = mysqli_real_escape_string($conn, $rawData['password']);
    $role = mysqli_real_escape_string($conn, $rawData['role']);
    $address = mysqli_real_escape_string($conn, $rawData['address']);
    $city = mysqli_real_escape_string($conn, $rawData['city']);
    $state = mysqli_real_escape_string($conn, $rawData['state']);
    $pincode = mysqli_real_escape_string($conn, $rawData['pincode']);

    // Handle image upload
    $imageDir = 'images/';
    $imagePath = $imageDir . basename($_FILES['store_image']['name']);
    if (!move_uploaded_file($_FILES['store_image']['tmp_name'], $imagePath)) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload image']);
        exit();
    }

    // Hash the password before storing it
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Begin transaction to ensure both inserts are successful
    $conn->begin_transaction();

    try {
        // Check if the username already exists in the login table
        $checkUsernameSql = "SELECT * FROM user_login WHERE Delete_status = 0 AND Username = '$username' LIMIT 1";
        $result = $conn->query($checkUsernameSql);
        if ($result->num_rows > 0) {
            throw new Exception("Username already exists");
        }

        // Insert into User table (profile)
        $userSql = "INSERT INTO user_profile (Name, Email, Password, Phone, Role, Created_date, Address, City, State, Pincode, store_image)
                    VALUES ('$name', '$email', '$hashedPassword', '$phone', '$role', CURDATE(), '$address', '$city', '$state', '$pincode', '$imagePath')";
        if ($conn->query($userSql) === FALSE) {
            throw new Exception("Error inserting into User table");
        }

        // Get the last inserted User_id for the Login table
        $user_id = $conn->insert_id;

        // Insert into Login table
        $loginSql = "INSERT INTO user_login (name, Email, Phone, Username, Password, role)
                     VALUES ('$name', '$email', '$phone', '$username', '$hashedPassword', '$role')";
        if ($conn->query($loginSql) === FALSE) {
            throw new Exception("Error inserting into Login table");
        }

        // Commit the transaction
        $conn->commit();

        // Send success response
        echo json_encode(['status' => 'success', 'message' => 'User added successfully']);

    } catch (Exception $e) {
        // Rollback the transaction if any query fails
        $conn->rollback();

        // Send error response
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    // If the method is not POST
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

// Close the database connection
$conn->close();
?>
