<?php  

include_once  'db.php'; 

header('Content-Type: application/json');


$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);


 $invoiceid =$data['invoiceid']; 

 if (empty($invoiceid)) {
    echo json_encode(['error' => 'invoice ID is required']);
    exit();
}


$invoiceDataQuery = "SELECT * FROM invoice_data WHERE invoice_id = '$invoiceid' AND Delete_status = 0";
$invoiceDataResult = mysqli_query($conn, $invoiceDataQuery);

	 

if (!$invoiceDataResult) {
    echo json_encode(['error' => 'Failed to fetch order data: ' . mysqli_error($conn)]);
    exit();
}

$invoices = [];
$taxValues = [];



while ($row = mysqli_fetch_assoc($invoiceDataResult)) {

    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }
    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';


    $invoices[] = [
        'productid' => $productid,
        'productname' => $productname,
        'mrp' =>  $row['MRP'],
        'saleprice' => $row['Selling_price'],
        'price' => '',
        'discountvalue' => $row['discount'],
        'discountpercentage' => $row['Discount_percentage'],
        'qty' => $row['qty'],
        'amount' => $row['Product_total'],
        'taxvalue' => $row['Tax'],
        'taxpercentage' => $row['Tax_percentage'],
        'salepricetax' => $row['salepricetax']
    ];

    $taxValues[] = $row['Tax'];

}

$invoiceHtml = '';

foreach ($invoices as $invoice) {

    $invoiceHtml .= "<tr class='align-items-top'>

        <td class='align-items-top productname'>

            {$invoice['productname']}

            <input type='hidden' id='productid' class='productid' name='productid[]' value='{$invoice['productid']}'>
            <input type='hidden' id='salepricetax' class='salepricetax' name='salepricetax[]' value='{$invoice['salepricetax']}'>
        </td>

        <td>

            <button type='button' name='remove' id='removeicon' class='' style='color:blue; font-weight:300; top: -100px; border:none;'>

                <i class='dw dw-cancel'></i>

            </button>

        </td>

        <td></td>

        <td class='align-items-top'>

            <input type='text' name='mrp[]' class='invTable mrp' value='{$invoice['mrp']}'>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable price' name='price[]' value='{$invoice['price']}'>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable discountvalue' name='discountvalue[]' value='{$invoice['discountvalue']}'>

            <br>

            <div style='position: relative; display: inline-block;'>

                <input class='invTable discountpercentage' name='discountpercentage[]' value='{$invoice['discountpercentage']}' style='margin-top:5px;' type='text'>

                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>

            </div>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable qty' name='qty[]' value='{$invoice['qty']}'>

        </td>

        <td class='align-items-top'>

            <div style='position: relative; display: inline-block;'>

                <input type='text' name='taxvalue1[]' class='invTable taxvalue' value='{$invoice['taxpercentage']}' style='padding-right: 20px; box-sizing: border-box;'>

                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>

            </div>

            <br>

            <span class='taxvalue-display'>₹" . number_format($invoice['taxvalue'], 2) . "</span>

        </td>

        <td></td>

        <td class='align-items-top amountspan'>" . number_format($invoice['amount'], 2) . "</td>

    </tr>";

}

echo json_encode(['invoiceHtml' => $invoiceHtml, 'taxValues' => $taxValues]);


// Close the database connection
mysqli_close($conn);

?>

