<?php

// Set headers for JSON response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database connection
include_once 'db.php';

// Fetch invoice ID from the request (GET or POST)
$invoiceID = isset($_REQUEST['invoiceID']) ? mysqli_real_escape_string($conn, $_REQUEST['invoiceID']) : null;

// Check if invoiceID is provided
if (!$invoiceID) {
    echo json_encode([
        "status" => "error",
        "message" => "Invoice ID is required"
    ]);
    exit;
}

error_reporting(0);

// Fetch profile information
$queryProfile = mysqli_query($conn, "SELECT * FROM invoicepdfdetails WHERE invoiceid='$invoiceID'");

if (!$queryProfile) {
    echo json_encode([
        "status" => "error",
        "message" => "Database query failed: " . mysqli_error($conn)
    ]);
    exit;
}

$profileData = mysqli_fetch_assoc($queryProfile);

if (!$profileData) {
    echo json_encode([
        "status" => "error",
        "message" => "No data found for the provided Invoice ID"
    ]);
    exit;
}

// Fetch invoice data (all products for this invoice)
$queryInvoiceData = "
    SELECT 
        i.invoice_id,
        i.Product_id,
        i.Selling_price,
        i.Tax_percentage,
        i.Tax,
        i.Product_total,
        i.Discount_percentage,
        i.Qty,
        i.MRP,
        p.Product_name,
        p.Delete_status
    FROM 
        invoice_data i
    INNER JOIN 
        product p 
    ON 
        i.Product_id = p.Product_id AND i. Delete_status=0
    WHERE 
        i.invoice_id = '$invoiceID' 
        AND p.Delete_status = 0";

$resultInvoiceData = mysqli_query($conn, $queryInvoiceData);

if (!$resultInvoiceData) {
    echo json_encode([
        "status" => "error",
        "message" => "Database query failed: " . mysqli_error($conn)
    ]);
    exit;
}

// Prepare invoice data array
$invoiceData = [];
while ($row = mysqli_fetch_assoc($resultInvoiceData)) {
    $taxvalue += $row['Tax'];
    $invoiceData[] = [
        "invoice_id" => $row['invoice_id'],
        "Product_id" => $row['Product_id'],
        "Product_name" => $row['Product_name'],
        "Selling_price" => $row['Selling_price'],
        "Tax_percentage" => $row['Tax_percentage'],
        "Tax" => $row['Tax'],
        "Qty" => $row['Qty'],
        "MRP" => $row['MRP'],
        "Discount_percentage" => $row['Discount_percentage'],
        "Product_total"=>$row['Product_total']
    ];
}

// Combine profile data and invoice data
$response = [
    "status" => "success",
    "profile" => $profileData,
    "invoice_data" => $invoiceData,
    "taxvalue" => $taxvalue
];

// Return JSON response
echo json_encode($response, JSON_PRETTY_PRINT);

?>
