
<?php
include_once 'db.php';

header('Content-Type: application/json');

// Get the date filter parameter from the request
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'today';

$currentDate = date('Y-m-d');
$yesterdayDate = date('Y-m-d', strtotime('-1 day'));
$currentMonth = date('Y-m');
$currentYear = date('Y');

$whereClause = "delete_status='0' AND customertype!=3";

// Determine the date filter
switch ($filter) {
    case 'yesterday':
        $whereClause .= " AND DATE(date) = '$yesterdayDate'";
        break;
    case 'month':
        $whereClause .= " AND DATE_FORMAT(date, '%Y-%m') = '$currentMonth'";
        break;
    case 'year':
        $whereClause .= " AND YEAR(date) = '$currentYear'";
        break;
    default: // today
        $whereClause .= " AND DATE(date) = '$currentDate'";
        break;
}


// Fetch customer count based on the selected filter
$customersql = "SELECT COUNT(id) AS totalcustomer FROM customer WHERE $whereClause";
$customerresult = mysqli_query($conn, $customersql);
$rowcustomer = mysqli_fetch_assoc($customerresult);

$response = [
    "totalcustomer" => $rowcustomer['totalcustomer'] ?? 0
];

echo json_encode($response);
?>
