<?php
// Include database connection
include('db.php');

// Fetch the latest order_id from the orders table
$query = "SELECT MAX(invoice_id) AS latest_invoice_id FROM invoice";
$result = mysqli_query($conn, $query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $latest_invoice_id = $row['latest_invoice_id'];

    // Increment the latest order_id by 1
    $new_invoice_id = $latest_invoice_id + 1;

    // Return the new order_id in JSON format
    echo json_encode([
        "status" => "success",
        "new_invoice_id" => $new_invoice_id
    ]);
} else {
    // Handle error in case of query failure
    echo json_encode([
        "status" => "error",
        "message" => "Failed to retrieve the latest order ID"
    ]);
}

mysqli_close($conn); // Close database connection
?>
