<?php
// Include database connection
include('db.php');

// Fetch the latest purchase_id from the purchases table
$query = "SELECT MAX(purchase_id) AS latest_purchase_id FROM purchase";
$result = mysqli_query($conn, $query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $latest_purchase_id = $row['latest_purchase_id'];

    // Increment the latest purchase_id by 1
    $new_purchase_id = $latest_purchase_id + 1;

    // Return the new purchase_id in JSON format
    echo json_encode([
        "status" => "success",
        "new_purchase_id" => $new_purchase_id
    ]);
} else {
    // Handle error in case of query failure
    echo json_encode([
        "status" => "error",
        "message" => "Failed to retrieve the latest purchase ID"
    ]);
}

mysqli_close($conn); // Close database connection
?>
