<?php
header("Content-Type: application/json");
include 'db.php'; // Ensure this connects correctly to your database

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

try {
    // Fetch filters from GET parameters
    $statusfilter = isset($_GET['statusfilter']) ? $_GET['statusfilter'] : null;
    $searchIcon = isset($_GET['searchIcon']) ? $_GET['searchIcon'] : null;
    $datetimepickersearch = isset($_GET['datetimepickersearch']) ? $_GET['datetimepickersearch'] : null;
    $customdate = isset($_GET['customdate']) ? $_GET['customdate'] : null;

    // Base SQL query
    $query = "SELECT 
                o.Order_id AS id,
                o.order_no AS orderid,
                i.invoice_no,
                o.time AS createdate,
                o.Grand_total AS total_amount,
                o.displayname,
                o.Store_status AS storestatus,
                o.Action_status AS orderstatus,
                o.Deliveryby AS deliveredby,
                o.Delivery_partner AS deliverystatus,
                o.Tracking_id AS dispathstatus,
                o.Delete_status AS status,
                o.Action_status AS actionstatus,
                o.Payment_status AS paymentstatus,
                o.Invoice_id AS invoiceid,
                c.displayname AS customername, 
                c.phonenumber AS customercontact,
                od.Product_id,
                GROUP_CONCAT(p.Product_name SEPARATOR '|') AS product_names,
                GROUP_CONCAT(p.Product_image SEPARATOR '|') AS product_images,
                (SELECT COUNT(*) FROM order_data WHERE order_data.Order_id = o.Order_id AND order_data.Delete_status=0) AS total_products
            FROM orders o
            INNER JOIN customer c ON c.id = o.user_id
            LEFT JOIN invoice i ON i.order_id = o.Order_id 
            INNER JOIN order_data od ON od.Order_id = o.Order_id AND od.Delete_status = 0
            INNER JOIN product p ON p.Product_id = od.Product_id
            WHERE o.Delete_status = 0";

    // Apply filters
    if (!empty($statusfilter)) {
        $query .= " AND o.Action_status = '" . mysqli_real_escape_string($conn, $statusfilter) . "'";
    }

    if (!empty($searchIcon)) {
        $query .= " AND (o.order_no LIKE '%" . mysqli_real_escape_string($conn, $searchIcon) . "%' 
                    OR o.displayname LIKE '%" . mysqli_real_escape_string($conn, $searchIcon) . "%')";
    }

    if (!empty($datetimepickersearch)) {
        $dates = explode(" - ", $datetimepickersearch); // Assuming date range is in "start - end" format
        if (count($dates) === 2) {
            $start_date = mysqli_real_escape_string($conn, trim($dates[0]));
            $end_date = mysqli_real_escape_string($conn, trim($dates[1]));
            $query .= " AND o.time BETWEEN '$start_date' AND '$end_date'";
        }
    }

    if (!empty($customdate)) {
        $query .= " AND DATE(o.time) = '" . mysqli_real_escape_string($conn, $customdate) . "'";
    }

    $query .= " GROUP BY o.Order_id ORDER BY o.Order_id DESC"; // Ensuring correct grouping

    // Execute query
    $result = mysqli_query($conn, $query);

    if (!$result) {
        echo json_encode(["status" => "error", "message" => "Failed to fetch data", "error_detail" => mysqli_error($conn)]);
        exit;
    }

    $orders = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $orders[] = [
            "id" => $row['id'],
            "orderid" => $row['orderid'],
            "invoiceno" => $row['invoice_no'] ?: "-",
            "createdate" => $row['createdate'],
            "total_amount" => $row['total_amount'],
            "displayname" => $row['displayname'],
            "storestatus" => $row['storestatus'],
            "orderstatus" => $row['orderstatus'],
            "deliveredby" => $row['deliveredby'],
            "deliverystatus" => $row['deliverystatus'],
            "dispathstatus" => $row['dispathstatus'],
            "status" => $row['status'],
            "actionstatus" => $row['actionstatus'],
            "paymentstatus" => $row['paymentstatus'],
            "invoiceid" => $row['invoiceid'],
            "customername" => $row['customername'],
            "customercontact" => $row['customercontact'],
            "total_products" => $row['total_products'],
            "product_names" => explode('|', $row['product_names']), // Array of product names
            "product_images" => explode('|', $row['product_images']), // Array of product images
            "totalproductcount" => $row['total_products'],
        ];
    }

    // Return the results as JSON
    echo json_encode($orders);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => "An error occurred", "error_detail" => $e->getMessage()]);
} finally {
    mysqli_close($conn);
}

?>
