<?php
// Set header for JSON response
header('Content-Type: application/json');

// Include database connection
include_once 'db.php';

// Initialize response array
$response = [];

// Get 'orderid' from POST
$orderid = isset($_POST['orderid']) ? trim($_POST['orderid']) : '';

if (empty($orderid)) {
    $response = [
        'status' => 'error',
        'message' => 'Order ID is required'
    ];
    echo json_encode($response);
    exit;
}

// Fetch order grand total
$query = "SELECT Order_id, Grand_total FROM orders WHERE Order_id='$orderid'";
$result = mysqli_query($conn, $query);

if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $grandtotal = $row['Grand_total'];

    // Fetch total customer payments
    $sqls = "SELECT SUM(Payment_amount) AS totalcustomerpayment FROM payment WHERE Order_id='$orderid'";
    $results = mysqli_query($conn, $sqls);

    if ($results) {
        $customerpaymentrow = mysqli_fetch_assoc($results);
        $totalcustomerpayment = $customerpaymentrow['totalcustomerpayment'] ?? 0;

        // Calculate total pending amount
        $totalpending = $grandtotal - $totalcustomerpayment;

        $response = [
            'status' => 'success',
            'data' => [
                'grandtotal' => $grandtotal,
                'totalcustomerpayment' => $totalcustomerpayment,
                'totalpending' => $totalpending
            ]
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'Error calculating customer payment: ' . mysqli_error($conn)
        ];
    }
} else {
    $response = [
        'status' => 'error',
        'message' => 'Order not found or invalid Order ID'
    ];
}

// Return JSON response
echo json_encode($response);
?>
