<?php

include_once 'db.php';

header('Content-Type: application/json');

// Get the date filter parameter from the request
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'today';

$currentDate = date('Y-m-d');
$yesterdayDate = date('Y-m-d', strtotime('-1 day'));
$currentMonth = date('Y-m');
$currentYear = date('Y');

$whereClause = "c.delete_status='0' AND c.customertype!=3 AND p.Delete_status=0";

// Determine the date filter
switch ($filter) {
    case 'yesterday':
        $whereClause .= " AND DATE(p.Payment_date) = '$yesterdayDate'";
        break;
    case 'month':
        $whereClause .= " AND DATE_FORMAT(p.Payment_date, '%Y-%m') = '$currentMonth'";
        break;
    case 'year':
        $whereClause .= " AND YEAR(p.Payment_date) = '$currentYear'";
        break;
    default: // today
        $whereClause .= " AND DATE(p.Payment_date) = '$currentDate'";
        break;
}


// Fetch customer count based on the selected filter
$customersql = "SELECT SUM(p.Payment_amount) AS totalamount 
                FROM payment p 
                LEFT JOIN customer c ON c.id = p.customer_id  
                WHERE $whereClause";
$customerresult = mysqli_query($conn, $customersql);
$rowcustomer = mysqli_fetch_assoc($customerresult);

$response = [
    "totalamount" => $rowcustomer['totalamount'] ?? 0
];

echo json_encode($response);
?>

