<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get raw input data and decode JSON
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Validate and sanitize input
    if (isset($data['id'])) {
        $categoryID = intval($data['id']); // Sanitize category ID to ensure it's an integer

        // Update query to set Delete_status to 1
        $sql = "UPDATE categories SET Delete_status = 1 WHERE category_ID = $categoryID";

        if ($conn->query($sql) === TRUE) {
            // Check if rows were affected
            if ($conn->affected_rows > 0) {
                echo json_encode(['status' => 'success', 'message' => 'Category deleted successfully']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Category not found or already deleted']);
            }
        } else {
            // Handle query error
            echo json_encode(['status' => 'error', 'message' => 'Failed to delete category', 'error_detail' => $conn->error]);
        }
    } else {
        // Missing category_ID in the request
        echo json_encode(['status' => 'error', 'message' => 'category_ID is required']);
    }
} else {
    // Method not allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method. Use POST.']);
}

// Close database connection
$conn->close();
?>
