<?php
include("db.php"); // Include your database connection

// Start the session (optional if needed for authentication)
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get raw POST data
    $rawData = file_get_contents('php://input');

    // Decode JSON input
    $data = json_decode($rawData, true);

    // Check for JSON decoding errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Validate required fields
    if (!isset($data['Product_id']) || !isset($data['Seo_title']) || !isset($data['Seo_description'])  || !isset($data['Keywords'])) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
        exit();
    }

    // Sanitize and assign variables
    $productId = intval($data['Product_id']);
    $seoTitle = $conn->real_escape_string($data['Seo_title']);
    $seoDescription = $conn->real_escape_string($data['Seo_description']);
    $keywords = $conn->real_escape_string($data['Keywords']);

    // Check if data exists for the given Product_id
    $checkSql = "SELECT Seo_id FROM product_seo WHERE Product_id = '$productId'";
    $result = $conn->query($checkSql);

    if ($result->num_rows > 0) {
        // Data exists, update the record
        $row = $result->fetch_assoc();
        $seoId = $row['Seo_id'];
        $sql = "UPDATE product_seo 
                SET Seo_title = '$seoTitle', Seo_description = '$seoDescription', Keywords = '$keywords'
                WHERE Seo_id = '$seoId'";
        $operation = "updated";
    } else {
        // Data does not exist, insert a new record
        $sql = "INSERT INTO product_seo (Product_id, Seo_title, Seo_description, Keywords)
                VALUES ('$productId', '$seoTitle', '$seoDescription', '$keywords')";
        $operation = "inserted";
    }

    // Execute the query
    if ($conn->query($sql) === TRUE) {
        $message = "SEO details $operation successfully";

        // If inserted, get the new Seo_id
        if ($operation === "inserted") {
            $seoId = $conn->insert_id;
        }

        echo json_encode([
            'status' => 'success',
            'message' => $message,
            'data' => [
                'Seo_id' => $seoId,
                'Product_id' => $productId,
                'Seo_title' => $seoTitle,
                'Seo_description' => $seoDescription,
                'Keywords' => $keywords,
                'Delete_status' => $deleteStatus
            ]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to save SEO details', 'error_detail' => $conn->error]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
