<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                       'Cart Id', 'Create Date', 'Customer Name', 'Customer Mobile', 'Delivery Mode', 'Pick Up Name',
                       'Pick Up Mobile', 'Sub Total', 'Shipping Charge', 'Packaging Charge', 'Payment Charge', 'Coupon Code', 
                       'Coupon Discount', 'Payment Discount', 'Tax Amount', 'Total Amount', 'UTM ID', 'UTM Campaign', 'Name',
                       'Mobile', 'Address', 'City', 'State', 'Pincode', 'SKU', 'Item Name', 'Item Qty', 'Item Price'
                        ];
                    }
                    $query = "SELECT 
                    c.Cart_id,
                    c.User_id,
                    c.Product_id,
                    c.Category_id,
                    c.Variant_id,
                    c.Quantity,
                    c.Created_Date,
                    c.removed_date,
                    u.displayname AS Name,
                    u.phoneno AS Phone,
                    u.address AS Address,
                    u.city AS City,
                    u.state AS State,
                    u.pincode AS Pincode,
                    pd.Product_name,
                    pd.SKU,
                    pd.HSN,
                    pd.Selling_price,
                    pd.tax
                  
                  
                  FROM 
                  cart c 
                  
                  LEFT JOIN 
                  product pd
                  ON
                  c.Product_id = pd.Product_id
                  LEFT JOIN 
                  customer u
                  ON 
                  c.User_id = u.id 
                  WHERE 
                  c.Delete_status = 1
                  AND u.Delete_status = 0";
                  
                  // Apply duration filters (last week, last month, etc.)
                  if ($duration == "Today") {
                    $query .= " AND DATE(c.Created_Date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(c.Created_Date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND c.Created_Date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND c.Created_Date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND c.Created_Date BETWEEN '$startDate' AND '$endDate'";
                }
                
                  
                  // Perform the query using MySQLi
                  $result = $conn->query($query);
                  $data = [];
                  if ($result) {
                      while ($row = $result->fetch_assoc()) {
                          $data[] = $row;
                      }
                  }
                  
                  // Generate the CSV file
                  if ($reportFormat == "Xlsx") {
                      $filePath = 'reports/abandonedcart_report_' . time() . '.csv';
                      $file = fopen($filePath, 'w');
                  
                      // Write the header row
                    // Header Array with Dynamic Filtering
$header = [];

// Dynamically add columns to the header using the filter array
if (in_array('Cart ID', $columns)) $header[] = 'Cart Id';
if (in_array('Create Date', $columns)) $header[] = 'create date';
if (in_array('Customer Name', $columns)) $header[] = 'customer name';
if (in_array('Customer Mobile', $columns)) $header[] = 'customer mobile';
if (in_array('Delivery Mode', $columns)) $header[] = 'delivery mode';
if (in_array('Pickup Name', $columns)) $header[] = 'pick up name';
if (in_array('Pickup Mobile', $columns)) $header[] = 'pick up mobile';
if (in_array('Sub Total', $columns)) $header[] = 'sub total';
if (in_array('Shipping Charge', $columns)) $header[] = 'shipping charge';
if (in_array('Packaging Charge', $columns)) $header[] = 'packaging charge';
if (in_array('Payment charge', $columns)) $header[] = 'payment charge';
if (in_array('Coupon Code', $columns)) $header[] = 'coupon code';
if (in_array('Coupon Discount', $columns)) $header[] = 'coupon discount';
if (in_array('Payment Discount', $columns)) $header[] = 'payment discount';
if (in_array('Tax Amount', $columns)) $header[] = 'tax amount';
if (in_array('total amount', $columns)) $header[] = 'total amount';
if (in_array('UTM ID', $columns)) $header[] = 'UTM ID';
if (in_array('UTM Campaign', $columns)) $header[] = 'UTM campaign';
if (in_array('Name', $columns)) $header[] = 'Name';
if (in_array('Mobile', $columns)) $header[] = 'mobile';
if (in_array('Address', $columns)) $header[] = 'Address';
if (in_array('City', $columns)) $header[] = 'city';
if (in_array('Sate', $columns)) $header[] = 'state';
if (in_array('Pincode', $columns)) $header[] = 'pincode';
if (in_array('SKU', $columns)) $header[] = 'SKU';
if (in_array('Item Name', $columns)) $header[] = 'Item name';
if (in_array('Item qty', $columns)) $header[] = 'Item qty';
if (in_array('Item Price', $columns)) $header[] = 'Item price';

// Write the header to the CSV file
fputcsv($file, $header);

// Write data rows dynamically
foreach ($data as $row) {
    $rowData = [];

    // Dynamically add values to rowData based on header inclusion
    if (in_array('cart-id', $columns)) $rowData[] = $row['cart_no'];
    if (in_array('create date', $columns)) $rowData[] = $row['Created_Date'];
    if (in_array('customer name', $columns)) $rowData[] = $row['Name'];
    if (in_array('customer mobile', $columns)) $rowData[] = $row['Phone'];
    if (in_array('delivery mode', $columns)) $rowData[] = '';
    if (in_array('pick up name', $columns)) $rowData[] = '';
    if (in_array('pick up mobile', $columns)) $rowData[] = '';
    
    // Calculate total based on selling price and quantity
    $total = $row['Selling_price'] * $row['Quantity'];

    // Add the calculated values dynamically
    if (in_array('sub total', $columns)) $rowData[] = '';
    if (in_array('shipping charge', $columns)) $rowData[] = '0.0';
    if (in_array('packaging charge', $columns)) $rowData[] = '0.0';
    if (in_array('payment charge', $columns)) $rowData[] = '0.0';
    if (in_array('coupon code', $columns)) $rowData[] = '0.0';
    if (in_array('coupon discount', $columns)) $rowData[] = '0.0';
    if (in_array('payment discount', $columns)) $rowData[] = '0.0';
    if (in_array('tax amount', $columns)) $rowData[] = $row['tax'];
    if (in_array('total amount', $columns)) $rowData[] = $total;

    // Add the static data dynamically
    if (in_array('UTM ID', $columns)) $rowData[] = '-';
    if (in_array('UTM campaign', $columns)) $rowData[] = '-';
    if (in_array('Name', $columns)) $rowData[] = $row['Name'];
    if (in_array('mobile', $columns)) $rowData[] = $row['Phone'];
    if (in_array('Address', $columns)) $rowData[] = $row['Address'];
    if (in_array('city', $columns)) $rowData[] = $row['City'];
    if (in_array('state', $columns)) $rowData[] = $row['State'];
    if (in_array('pincode', $columns)) $rowData[] = $row['Pincode'];
    if (in_array('SKU', $columns)) $rowData[] = $row['SKU'];
    if (in_array('Item name', $columns)) $rowData[] = $row['Product_name'];
    if (in_array('Item qty', $columns)) $rowData[] = $row['Quantity'];
    if (in_array('Item price', $columns)) $rowData[] = $row['Selling_price'];

    // Write the row to the CSV file
    fputcsv($file, $rowData);
}

// Close the file
fclose($file);

                  $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                  $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                  $report_no_result = mysqli_query($conn, $report_no_query);
                  $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                  $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                  $durationText = $duration ?? 'N/A';
                  $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                            VALUES ('$reportNo','Abanddonedcart Report', NOW(), '$durationText', '$finalpath', 0)";
                  $conn->query($insertQuery);
                  
                  echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                  } elseif ($reportFormat == "pdf") {
                  $filePath = 'reports/adanbordedcart_report_' . time() . '.pdf';
                  
                  // Create a new PDF document
                  $pdf = new FPDF('L', 'mm', array(1280, 700));
                  
                  $pdf->AddPage();
                  $pdf->SetFont('Arial', 'B', 12);
                  
                  // Table headers
                  $headers = [
                      'cart-id', 
                      'create date', 
                      'customer name', 
                      'customer moblie', 
                      'delivery mode',
                      'pick up name', 
                      'pick up moblie', 
                      'sub total', 
                      'shipping charge', 
                      'packaging charge',
                      'payment charge', 
                      'coupon code', 
                      'coupon discount', 
                      'payment discount', 
                      'tax amount',
                      'total amount', 
                      'UTM ID', 
                      'UTM campaign', 
                      'Name', 
                      'mobile',
                      'Address',
                      'city', 
                      'state', 
                      'pincode', 
                      'SKU', 
                      'Item name',
                      'Item qty',
                      'Item price'
                  ];
                  
                  
                  // Set column widths
                  $colWidths = array_fill(0, count($headers), 45); // Adjust column widths as needed
                  $rowHeight = 8;
                  
                  // Print header row
                  foreach ($headers as $index => $header) {
                  $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                  }
                  $pdf->Ln(); // Move to the next row
                  
                  // Print data rows
                  foreach ($data as $row) {
                      $total = $row['Selling_price'] * $row['Quantity'];
                  $values = [
                              $row['cart_no'],              
                              $row['Created_Date'], 
                              $row['Name'],
                              $row['Phone'],
                              '',
                              '',
                              '',
                              $total,
                              '0.0',
                              '0.0',                        
                              '0.0', 
                              '0.0', 
                              '0.0',               
                             '0.0',     
                             $row['tax'],  
                             $total,
                             '-',
                             '-',
                             $row['Name'],
                             $row['Phone'],
                             $row['Address'],
                             $row['City'],
                             $row['State'],
                             $row['Pincode'],
                             $row['SKU'],
                             $row['Product_name'],
                             $row['Quantity'], 
                             $row['Selling_price']        
                            
                  ];
                  
                  foreach ($values as $index => $value) {
                    $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                  }
                  $pdf->Ln(); // Move to the next row
                  }
                  
                  // Save the PDF file
                  $pdf->Output('F', $filePath);
                  
                  $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                  $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                  $report_no_result = mysqli_query($conn, $report_no_query);
                  $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                  $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                  $durationText = $duration ?? 'N/A';
                  $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                           VALUES ('$reportNo','Abandonedcart Report', NOW(), '$durationText', '$finalpath', 0)";
                  $conn->query($insertQuery);
                  
                  echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                  } else {
                  echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                  }
                  
                }
            }
            ?>