<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                        'Item Sku', 'Item Name',
                        'Quantity', 'Lowest MRP',
                        'Highest MRP', 'Lowest Sale Price',
                        'Highest Sale Price', 'Live Sale Price',
                         'Live Inventory Value'
                        ];
                    }
                    $query = "SELECT 
                    p.Product_id,
                    p.Product_name,
                    p.MRP,
                    p.HSN,
                    p.qty,
                    p.SKU,
                    p.Selling_price,
                    p.date
                 
                FROM 
                    product p
                WHERE 
                    p.Delete_status = 0";
                
                // Apply duration filters (last week, last month, etc.)
                if ($duration == "Today") {
                    $query .= " AND DATE(p.date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(p.date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND p.date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND p.date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND p.date BETWEEN '$startDate' AND '$endDate'";
                }
                
                
                
                
                // Perform the query using MySQLi
                $result = $conn->query($query);
                $data = [];
                while ($row = $result->fetch_assoc()) {
                $data[] = $row;
                }
                
                // Generate the CSV file
                if ($reportFormat == "Xlsx") {
                $filePath = 'reports/inventory_report_' . time() . '.csv';
                $file = fopen($filePath, 'w');
                
                $header = [];
                if (in_array('Item SKU', $columns)) $header[] = 'Item Sku';
                if (in_array('Item Name', $columns)) $header[] = 'Item Name';
                if (in_array('Quantity', $columns)) $header[] = 'Quantity';
                if (in_array('Lowest MRP', $columns)) $header[] = 'Lowest MRP';
                if (in_array('Highest MRP', $columns)) $header[] = 'Highest MRP';
                if (in_array('Lowest Sale Price', $columns)) $header[] = 'Lowest Sale Price';
                if (in_array('Highest Sale Price', $columns)) $header[] = 'Highest Sale Price';
                if (in_array('Live Sale Price', $columns)) $header[] = 'Live Sale Price';
                if (in_array('Live Inventory Value', $columns)) $header[] = 'Live Inventory Value';
                
                // Write the header to the CSV file
                fputcsv($file, $header);
                
                // Write data rows based on the dynamic header
                foreach ($data as $row) {
                    $rowData = [];
                    if (in_array('Item SKU', $columns)) $rowData[] = isset($row['SKU']) ? $row['SKU'] : '';
                    if (in_array('Item Name', $columns)) $rowData[] = isset($row['Product_name']) ? $row['Product_name'] : '';
                    if (in_array('Quantity', $columns)) $rowData[] = isset($row['qty']) ? $row['qty'] : '';
                    if (in_array('Lowest MRP', $columns)) $rowData[] = isset($row['MRP']) ? $row['MRP'] : '';
                    if (in_array('Highest MRP', $columns)) $rowData[] = isset($row['MRP']) ? $row['MRP'] : '';  
                    if (in_array('Lowest Sale Price', $columns)) $rowData[] = isset($row['Selling_price']) ? $row['Selling_price'] : '';
                    if (in_array('Highest Sale Price', $columns)) $rowData[] = isset($row['Selling_price']) ? $row['Selling_price'] : '';  
                    if (in_array('Live Sale Price', $columns)) $rowData[] = isset($row['Selling_price']) ? $row['Selling_price'] : '';
                    if (in_array('Live Inventory Value', $columns))$rowData[] =$row['qty'] ;
                    fputcsv($file, $rowData);
                }
                fclose($file);
                
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                          VALUES ('$reportNo','Inventory Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                } elseif ($reportFormat == "pdf") {
                $filePath = 'reports/inventory_report_' . time() . '.pdf';
                
                // Create a new PDF document
                $pdf = new FPDF('L', 'mm', array(400, 300));
                
                $pdf->AddPage();
                $pdf->SetFont('Arial', 'B', 12);
                
                // Table headers
                $headers = [
                  'Item Sku',
                    'Item Name',
                    'Quantity',
                    'Lowest MRP',
                    'Highest MRP',
                    'Lowest Sale Price',
                    'Highest Sale Price',
                    'Live Sale Price',
                    'Live Inventory Value'
                ];
                
                // Set column widths
                $colWidths = array_fill(0, count($headers), 42); // Adjust column widths as needed
                $rowHeight = 8;
                
                // Print header row
                foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                
                // Print data rows
                foreach ($data as $row) {
                
                $values = [
                    $row['SKU'], 
                    $row['Product_name'],  
                    $row['qty'], 
                    $row['MRP'],
                    $row['MRP'],
                    $row['Selling_price'],
                    $row['Selling_price'],
                    $row['Selling_price'],
                    $row['qty'] 
                 
                ];
                
                foreach ($values as $index => $value) {
                  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                }
                
                // Save the PDF file
                $pdf->Output('F', $filePath);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                         VALUES ('$reportNo','Inventory Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                } else {
                echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                }
                
                
                
               

                }
            }
?>