<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;
                    if (empty($columns)) {
                        $columns = [
                           'Invoice Id', 'Invoice Date', 'Create Date', 'Order Id', 'Customer Name', 'Customer Mobile', 'Coupon Code', 'Sale Price', 'Shipping Charge', 'Packaging Charge', 'Payment Charge', 'Payment Discount', 'Coupon Discount', 'Round Off', 'Discount', 'Tax Amount', 'Total Amount', 'Due Amount', 'Created By', 'Modified By'
                        ];
                    }

             
                        $query = "SELECT 
                      i.invoice_id, 
                      i.invoice_no, 
                      o.order_no, 
                      i.created_date AS Created_at, 
                      i.Created_id, 
                      i.Editor_id, 
                      i.user_id, 
                      i.created_date AS invoice_date, 
                      i.Grand_total,
                      i.Total_price,
                      i.Total_discount,
                      i.Tax,
                      i.Roundoff,
                      i.Balance,
                      i.Shipping,
                      i.Discount,
                      i.Coupon_code,
                      i.Coupon_amount,
                      i.Payment_status,
                      i.Due_date,
                      u.displayname AS Customer_Name, 
                      u.phoneno AS Customer_Mobile, 
                      u.Address, 
                      u.City, 
                      u.State, 
                      u.Pincode
                  FROM 
                       invoice i
                  LEFT JOIN 
                      orders o
                  ON 
                      i.invoice_id = o.Invoice_id
                  LEFT JOIN 
                      customer u 
                  ON 
                      i.user_id = u.id
                  WHERE 
                      o.Delete_status = 0";
                  
                  // Apply duration filters (last week, last month, etc.)
                  if ($duration == "Today") {
                    $query .= " AND DATE(o.Created_date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(o.Created_date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
                }
                
                  
                  // Perform the query using MySQLi
                  $result = $conn->query($query);
                  $data = [];
                  while ($row = $result->fetch_assoc()) {
                  $data[] = $row;
                  }
                  
                  // Generate the CSV file
                  if ($reportFormat == "Xlsx") {
                  $filePath = 'reports/invoice_report_' . time() . '.csv';
                  $file = fopen($filePath, 'w');
                  
                  // Write the header row
                  $header = [];

                  // Check and add columns dynamically to the header
                  if (in_array('Invoice ID', $columns)) $header[] = 'Invoice Id';
                  if (in_array('Invoice Date', $columns)) $header[] = 'Invoice Date';
                  if (in_array('Create Date', $columns)) $header[] = 'Create Date';
                  if (in_array('Order ID', $columns)) $header[] = 'Order Id';
                  if (in_array('Customer Name', $columns)) $header[] = 'Customer Name';
                  if (in_array('Customer Mobile', $columns)) $header[] = 'Customer Mobile';
                  if (in_array('Coupon Code', $columns)) $header[] = 'Coupon Code';
                  if (in_array('Sale Price', $columns)) $header[] = 'Sale Price';
                  if (in_array('Shipping Charge', $columns)) $header[] = 'Shipping Charge';
                  if (in_array('Packaging Charge', $columns)) $header[] = 'Packaging Charge';
                  if (in_array('Payment Charge', $columns)) $header[] = 'Payment Charge';
                  if (in_array('Payment Discount', $columns)) $header[] = 'Payment Discount';
                  if (in_array('Coupon Discount', $columns)) $header[] = 'Coupon Discount';
                  if (in_array('Round Off', $columns)) $header[] = 'Round Off';
                  if (in_array('Discount', $columns)) $header[] = 'Discount';
                  if (in_array('Tax Amount', $columns)) $header[] = 'Tax Amount';
                  if (in_array('Total Amount', $columns)) $header[] = 'Total Amount';
                  if (in_array('Due Amount', $columns)) $header[] = 'Due Amount';
                  if (in_array('Created By', $columns)) $header[] = 'Created By';
                  if (in_array('Modified By', $columns)) $header[] = 'Modified By';
                  
                  // Write the header to CSV
                  fputcsv($file, $header);
                  
                  // Write the data rows to CSV
                  foreach ($data as $row) {
                      $rowData = [];
                  
                      // Mapping columns from the selected ones in $columns to the corresponding data from $row
                      if (in_array('Invoice ID', $columns)) $rowData[] = isset($row['invoice_no']) ? $row['invoice_no'] : '';
                      if (in_array('Invoice Date', $columns)) $rowData[] = isset($row['invoice_date']) ? $row['invoice_date'] : '';
                      if (in_array('Create Date', $columns)) $rowData[] = isset($row['Created_at']) ? $row['Created_at'] : '';
                      if (in_array('Order ID', $columns)) $rowData[] = isset($row['order_no']) ? $row['order_no'] : '';
                      if (in_array('Customer Name', $columns)) $rowData[] = isset($row['Customer_Name']) ? $row['Customer_Name'] : '';
                      if (in_array('Customer Mobile', $columns)) $rowData[] = isset($row['Customer_Mobile']) ? $row['Customer_Mobile'] : '';
                      if (in_array('Coupon Code', $columns)) $rowData[] = isset($row['Coupon_code']) ? $row['Coupon_code'] : '';
                      if (in_array('Sale Price', $columns)) $rowData[] = isset($row['Total_price']) ? $row['Total_price'] : '';
                      if (in_array('Shipping Charge', $columns)) $rowData[] = isset($row['Shipping']) ? $row['Shipping'] : '';
                      if (in_array('Packaging Charge', $columns)) $rowData[] = ''; // Empty field if not in data
                      if (in_array('Payment Charge', $columns)) $rowData[] = ''; // Empty field if not in data
                      if (in_array('Payment Discount', $columns)) $rowData[] = isset($row['Coupon_amount']) ? $row['Coupon_amount'] : '';
                      if (in_array('Coupon Discount', $columns)) $rowData[] = isset($row['Roundoff']) ? $row['Roundoff'] : '';
                      if (in_array('Round Off', $columns)) $rowData[] = isset($row['Discount']) ? $row['Discount'] : '';
                      if (in_array('Discount', $columns)) $rowData[] = isset($row['Tax']) ? $row['Tax'] : '';
                      if (in_array('Tax Amount', $columns)) $rowData[] = isset($row['Grand_total']) ? $row['Grand_total'] : '';
                      if (in_array('Total Amount', $columns)) $rowData[] = isset($row['Balance']) ? $row['Balance'] : '';
                      if (in_array('Due Amount', $columns)) $rowData[] = isset($row['Created_id']) ? $row['Created_id'] : '';
                      if (in_array('Created By', $columns)) $rowData[] = isset($row['Editor_id']) ? $row['Editor_id'] : '';
                      if (in_array('Modified By', $columns)) $rowData[] = isset($row['Modified_id']) ? $row['Modified_id'] : '';
                  
                      fputcsv($file, $rowData);
                  }
                  
                  fclose($file);
                  
                  $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                  $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                  $report_no_result = mysqli_query($conn, $report_no_query);
                  $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                  $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                  $durationText = $duration ?? 'N/A';
                  $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                              VALUES ('$reportNo','Invoice Report' , NOW(), '$durationText', '$finalpath', 0)";
                  $conn->query($insertQuery);
                  
                  echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                  } elseif ($reportFormat == "pdf") {
                  $filePath = 'reports/invoice_report_' . time() . '.pdf';
                  
                  // Create a new PDF document
                  $pdf = new FPDF('L', 'mm', array(720, 700));
                  
                  $pdf->AddPage();
                  $pdf->SetFont('Arial', 'B', 12);
                  
                  // Table headers
                  $headers = [
                      'Invoice Id',
                      'Invoice Date',
                      'Create Date',
                      'Order Id',
                      'Customer Name',
                      'Customer Mobile',
                      'Coupon Code',
                      'Sale Price',
                      'Shipping Charge',
                      'Packaging Charge',
                      'Payment Charge',
                      'Payment Discount',
                      'Coupon Discount',
                      'Round Off',
                      'Discount',
                      'Tax Amount',
                      'Total Amount',
                      'Due Amount',
                      'Created By',
                      'Modified By'
                  ];
                  
                  // Set column widths
                  $colWidths = array_fill(0, count($headers), 35); // Adjust column widths as needed
                  $rowHeight = 8;
                  
                  // Print header row
                  foreach ($headers as $index => $header) {
                  $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                  }
                  $pdf->Ln(); // Move to the next row
                  
                  // Print data rows
                  foreach ($data as $row) {
                  $values = [
                      $row['invoice_no'], 
                      $row['invoice_date'], 
                      $row['Created_at'], 
                      $row['order_no'], 
                      $row['Customer_Name'], 
                      $row['Customer_Mobile'],
                      $row['Coupon_code'], 
                      $row['Total_price'], 
                      $row['Shipping'], 
                      '', 
                      '', 
                      '', 
                      $row['Coupon_amount'], 
                      $row['Roundoff'], 
                      $row['Discount'], 
                      $row['Tax'], 
                      $row['Grand_total'], 
                      $row['Balance'], 
                      $row['Created_id'], 
                      $row['Editor_id'] 
                  ];
                  
                  foreach ($values as $index => $value) {
                      $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                  }
                  $pdf->Ln(); // Move to the next row
                  }
                  
                  // Save the PDF file
                  $pdf->Output('F', $filePath);
                  
                  $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                  $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                  $report_no_result = mysqli_query($conn, $report_no_query);
                  $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                  $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                  $durationText = $duration ?? 'N/A';
                  $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                             VALUES ('$reportNo','Invoice Report', NOW(), '$durationText', '$finalpath', 0)";
                  $conn->query($insertQuery);
                  
                  echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                  } else {
                  echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                  }
                  
                  }
                }
?>