<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

    if ($inputData) {
        // Get form data from the decoded JSON
        $reportType = $inputData['report_type'];
        $duration = $inputData['duration'];
        $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
        $reportFormat = $inputData['report_format'];
        $startDate = $inputData['start_date'] ?? null;
        $endDate = $inputData['end_date'] ?? null;

        // If no columns are selected, default to all columns
        if (empty($columns)) {
            $columns = [
                'Order Id', 'Order Date', 'Order Status', 'Invoice Id', 'Invoice Date',
                'Customer Name', 'Customer Mobile', 'Cancel Reason', 'Sale Price',
                'Shipping Charge', 'Packaging Charge', 'Payment Charge', 'Payment Discount',
                'Coupon Discount', 'Coupon Code', 'Round Off', 'Discount', 'Tax Amount',
                'Total Amount', 'Earn Points', 'Redeem Points', 'Due Amount',
                'Delivery Mode', 'Payment Mode', 'Express Delivery', 'Delivery Slot',
                'Delivery Start At', 'Delivery End At', 'Delivery Partner Name',
                'Delivery Tracking Id', 'Contact Name', 'Contact Mobile', 'Street1',
                'Street2', 'City', 'State', 'Pincode', 'UTM Id', 'UTM Campaign',
                'Created By', 'Modified By'
            ];
        }

        // Query to fetch data
        $query = "SELECT 
                    o.Order_id, 
                    o.Invoice_id, 
                    i.invoice_no,
                    i.created_date AS invoice_date, 
                    o.order_no, 
                    o.user_id, 
                    o.Created_date AS Order_Date, 
                    o.Due_date, 
                    o.Balance, 
                    o.Tax, 
                    o.Tax_percentage, 
                    o.Discount, 
                    o.Discount_percentage, 
                    o.Shipping, 
                    o.Roundoff, 
                    o.Coupon_code, 
                    o.Coupon_amount, 
                    o.Total_saving, 
                    o.Total_price, 
                    o.No_of_items, 
                    o.Delivery_partner, 
                    o.Deliveryby, 
                    o.Tracking_id, 
                    o.Delivery_date, 
                    o.Confirmed_date, 
                    o.Action_status, 
                    o.Total_discount, 
                    o.Grand_total, 
                    o.Payment_status, 
                    o.Store_status, 
                    o.Created_id, 
                    o.Editor_id,
                    u.displayname AS Customer_Name, 
                    u.phoneno AS Customer_Mobile, 
                    u.address AS Address, 
                    u.city AS City, 
                    u.state AS State, 
                    u.pincode AS Pincode
                FROM 
                    orders o
                LEFT JOIN 
                    invoice i 
                ON 
                    o.Invoice_id = i.invoice_id
                LEFT JOIN 
                    customer u 
                ON 
                    o.user_id = u.id
                WHERE 
                    o.Delete_status = 0";

        // Apply duration filters
        if ($duration == "Today") {
            $query .= " AND DATE(o.Created_date) = CURDATE()";
        } elseif ($duration == "Yesterday") {
            $query .= " AND DATE(o.Created_date) = CURDATE() - INTERVAL 1 DAY";
        } elseif ($duration == "Last Week") {
            $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
        } elseif ($duration == "Last Month") {
            $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
        } elseif ($duration == "Custom" && $startDate && $endDate) {
            $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
        }

        // Perform the query using MySQLi
        $result = $conn->query($query);
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        // Generate the CSV file
        if ($reportFormat == "Xlsx") {
            $filePath = 'reports/order_report_' . time() . '.csv';
            $file = fopen($filePath, 'w');

            // Write the header row based on the selected columns
            $header = [];
            foreach ($columns as $column) {
                $header[] = $column;
            }

            // Write the header to the CSV file
            fputcsv($file, $header);

            // Write the data rows, only for selected columns
            foreach ($data as $row) {
                $rowData = [];
                foreach ($columns as $column) {
                    switch ($column) {
                        case 'Order Id':
                            $rowData[] = $row['order_no'];
                            break;
                        case 'Order Date':
                            $rowData[] = $row['Order_Date'];
                            break;
                        case 'Order Status':
                            $rowData[] = $row['Action_status'];
                            break;
                        case 'Invoice Id':
                            $rowData[] = $row['invoice_no'];
                            break;
                        case 'Invoice Date':
                            $rowData[] = $row['invoice_date'];
                            break;
                        case 'Customer Name':
                            $rowData[] = $row['Customer_Name'];
                            break;
                        case 'Customer Mobile':
                            $rowData[] = $row['Customer_Mobile'];
                            break;
                        case 'Cancel Reason':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Sale Price':
                            $rowData[] = $row['Total_price'];
                            break;
                        case 'Shipping Charge':
                            $rowData[] = $row['Shipping'];
                            break;
                        case 'Packaging Charge':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Payment Charge':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Payment Discount':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Coupon Discount':
                            $rowData[] = $row['Coupon_amount'];
                            break;
                        case 'Coupon Code':
                            $rowData[] = $row['Coupon_code'];
                            break;
                        case 'Round Off':
                            $rowData[] = $row['Roundoff'];
                            break;
                        case 'Discount':
                            $rowData[] = $row['Discount'];
                            break;
                        case 'Tax Amount':
                            $rowData[] = $row['Tax'];
                            break;
                        case 'Total Amount':
                            $rowData[] = $row['Grand_total'];
                            break;
                        case 'Earn Points':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Redeem Points':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Due Amount':
                            $rowData[] = $row['Balance'];
                            break;
                        case 'Delivery Mode':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Payment Mode':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Express Delivery':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Delivery Slot':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Delivery Start At':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Delivery End At':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Delivery Partner Name':
                            $rowData[] = $row['Delivery_partner'];
                            break;
                        case 'Delivery Tracking Id':
                            $rowData[] = $row['Tracking_id'];
                            break;
                        case 'Contact Name':
                            $rowData[] = $row['Customer_Name'];
                            break;
                        case 'Contact Mobile':
                            $rowData[] = $row['Customer_Mobile'];
                            break;
                        case 'Street1':
                            $rowData[] = $row['Address'];
                            break;
                        case 'Street2':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'City':
                            $rowData[] = $row['City'];
                            break;
                        case 'State':
                            $rowData[] = $row['State'];
                            break;
                        case 'Pincode':
                            $rowData[] = $row['Pincode'];
                            break;
                        case 'UTM Id':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'UTM Campaign':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Created By':
                            $rowData[] = $row['Created_id'];
                            break;
                        case 'Modified By':
                            $rowData[] = $row['Editor_id'];
                            break;
                        default:
                            $rowData[] = '';
                            break;
                    }
                }

                fputcsv($file, $rowData);
            }

            fclose($file);

            // Insert report details into the database
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);
            $durationText = $duration ?? 'N/A';
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $insertQuery = "INSERT INTO reports (Report_no, report_name, date, Duration, Excel_path, Delete_status) 
                            VALUES ('$reportNo', 'Order report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);

            echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
        } elseif ($reportFormat == "pdf") {
            $filePath = 'reports/order_report_' . time() . '.pdf';

            // Create a new PDF document
            $pdf = new FPDF('L', 'mm', array(1500, 700));
            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 12);

            // Table headers
            $headers = $columns;

            // Set column widths
            $colWidths = array_fill(0, count($headers), 40); // Adjust column widths as needed
            $rowHeight = 8;

            // Print header row
            foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row

            // Print data rows
            foreach ($data as $row) {
                $values = [];
                foreach ($columns as $column) {
                    switch ($column) {
                        case 'Order Id':
                            $values[] = $row['order_no'];
                            break;
                        case 'Order Date':
                            $values[] = $row['Order_Date'];
                            break;
                        case 'Order Status':
                            $values[] = $row['Action_status'];
                            break;
                        case 'Invoice Id':
                            $values[] = $row['invoice_no'];
                            break;
                        case 'Invoice Date':
                            $values[] = $row['invoice_date'];
                            break;
                        case 'Customer Name':
                            $values[] = $row['Customer_Name'];
                            break;
                        case 'Customer Mobile':
                            $values[] = $row['Customer_Mobile'];
                            break;
                        case 'Cancel Reason':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Sale Price':
                            $values[] = $row['Total_price'];
                            break;
                        case 'Shipping Charge':
                            $values[] = $row['Shipping'];
                            break;
                        case 'Packaging Charge':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Payment Charge':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Payment Discount':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Coupon Discount':
                            $values[] = $row['Coupon_amount'];
                            break;
                        case 'Coupon Code':
                            $values[] = $row['Coupon_code'];
                            break;
                        case 'Round Off':
                            $values[] = $row['Roundoff'];
                            break;
                        case 'Discount':
                            $values[] = $row['Discount'];
                            break;
                        case 'Tax Amount':
                            $values[] = $row['Tax'];
                            break;
                        case 'Total Amount':
                            $values[] = $row['Grand_total'];
                            break;
                        case 'Earn Points':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Redeem Points':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Due Amount':
                            $values[] = $row['Balance'];
                            break;
                        case 'Delivery Mode':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Payment Mode':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Express Delivery':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Delivery Slot':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Delivery Start At':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Delivery End At':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Delivery Partner Name':
                            $values[] = $row['Delivery_partner'];
                            break;
                        case 'Delivery Tracking Id':
                            $values[] = $row['Tracking_id'];
                            break;
                        case 'Contact Name':
                            $values[] = $row['Customer_Name'];
                            break;
                        case 'Contact Mobile':
                            $values[] = $row['Customer_Mobile'];
                            break;
                        case 'Street1':
                            $values[] = $row['Address'];
                            break;
                        case 'Street2':
                            $values[] = ''; // Placeholder
                            break;
                        case 'City':
                            $values[] = $row['City'];
                            break;
                        case 'State':
                            $values[] = $row['State'];
                            break;
                        case 'Pincode':
                            $values[] = $row['Pincode'];
                            break;
                        case 'UTM Id':
                            $values[] = ''; // Placeholder
                            break;
                        case 'UTM Campaign':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Created By':
                            $values[] = $row['Created_id'];
                            break;
                        case 'Modified By':
                            $values[] = $row['Editor_id'];
                            break;
                        default:
                            $values[] = '';
                            break;
                    }
                }

                foreach ($values as $index => $value) {
                    $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
            }

            // Save the PDF file
            $pdf->Output('F', $filePath);

            // Insert report details into the database
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no, report_name, date, Duration, Excel_path, Delete_status) 
                            VALUES ('$reportNo', 'Order report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);

            echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
        }
    }
}
?>