<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                            'Order Id', 
                        'Order Date', 
                        'Order Status', 
                        'Type', 
                        'Invoice Id', 
                        'Invoice Date', 
                        'Customer Name', 
                        'Customer Mobile',
                        'Cancel Reason', 
                        'Sale Price', 
                        'Shipping Charge', 
                        'Payment Charge', 
                        'Packaging Charge', 
                        'Coupon Discount',
                        'Coupon Code', 
                        'Round Off',
                        'Discount', 
                        'Payment Discount', 
                        'Tax Amount', 
                        'Earn Points', 
                        'Redeem Points', 
                        'Due Amount', 
                        'Total Amount', 
                        'Delivery Mode', 
                        'Payment Mode', 
                        'Express Delivery', 
                        'Delivery Slot', 
                        'Delivery Start At', 
                        'Delivery End At',
                        'Delivery Tracking Id', 
                        'Contact Name', 
                        'Contact Mobile', 
                        'Street1', 
                        'Street2', 
                        'City', 
                        'State',
                        'Pincode', 
                        'UTM Id', 
                        'UTM Campaign', 
                        'Delivery Partner Name', 
                        'Delivery Name', 
                        'Item Name', 
                        'Item Sku', 
                        'Item Price', 
                        'Item Qty', 
                        'HSN', 
                        'State', 
                        'State Code', 
                        'SGST', 
                        'SGST%', 
                        'CGST', 
                        'CGST%', 
                        'IGST', 
                        'IGST%', 
                        'CESS', 
                        'CESS%', 
                        'Item Tax', 
                        'Item Total', 
                        'Created By', 
                        'Modified By'
                        ];
                    }
                    $query = "SELECT 
                    o.Order_id,
                    o.order_no,
                    o.Created_date AS order_date,
                    o.Balance AS due_amount,
                    o.Tax AS oTax,
                    o.Grand_total AS oGrand_total,  
                    o.Action_status AS oAction_status, 
                    o.Store_status AS oStore_status,
                    o.Created_id AS oCreated_id,   
                    o.Editor_id AS oEditor_id, 
                    o.Deliveryby,
                    o.Tracking_id,
                    o.Delivery_partner,      
                    i.*,                
                    od.*,
                    od.Tax AS iTax,               
                    pd.Product_name,
                    pd.SKU,
                    pd.HSN,
                    pd.MRP,
                    pd.Selling_price AS iSelling_price,
                    pd.Tax, 
                    pd.qty AS iQty,               
                    p.*,                
                    u.*                  
                FROM 
                orders o
                LEFT JOIN 
                invoice i 
                ON 
                o.Invoice_id = i.invoice_id
                LEFT JOIN
                order_data od
                ON
                o.Order_id = od.Order_id
                LEFT JOIN 
                product pd
                ON
                od.Product_id = pd.Product_id
                LEFT JOIN 
                payment p 
                ON 
                o.Order_id = p.Order_id
                LEFT JOIN 
                customer u
                ON 
                o.User_id = u.id 
                WHERE 
                o.Delete_status = 0
                AND p.Delete_status = 0";
                
                // Apply duration filters (last week, last month, etc.)
                if ($duration == "Today") {
                    $query .= " AND DATE(o.Created_date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(o.Created_date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
                }
                
                
                // Perform the query using MySQLi
                $result = $conn->query($query);
                $data = [];
                if ($result) {
                    while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                    }
                }
                
                // Generate the CSV file
                if ($reportFormat == "Xlsx") {
                    $filePath = 'reports/order_order_item_report_' . time() . '.csv';
                    $file = fopen($filePath, 'w');
                
                    // Write the header row
                    $header = [
                        'Order Id', 
                        'Order Date', 
                        'Order Status', 
                        'Type', 
                        'Invoice Id', 
                        'Invoice Date', 
                        'Customer Name', 
                        'Customer Mobile',
                        'Cancel Reason', 
                        'Sale Price', 
                        'Shipping Charge', 
                        'Payment Charge', 
                        'Packaging Charge', 
                        'Coupon Discount',
                        'Coupon Code', 
                        'Round Off',
                        'Discount', 
                        'Payment Discount', 
                        'Tax Amount', 
                        'Earn Points', 
                        'Redeem Points', 
                        'Due Amount', 
                        'Total Amount', 
                        'Delivery Mode', 
                        'Payment Mode', 
                        'Express Delivery', 
                        'Delivery Slot', 
                        'Delivery Start At', 
                        'Delivery End At',
                        'Delivery Tracking Id', 
                        'Contact Name', 
                        'Contact Mobile', 
                        'Street1', 
                        'Street2', 
                        'City', 
                        'State',
                        'Pincode', 
                        'UTM Id', 
                        'UTM Campaign', 
                        'Delivery Partner Name', 
                        'Delivery Name', 
                        'Item Name', 
                        'Item Sku', 
                        'Item Price', 
                        'Item Qty', 
                        'HSN', 
                        'State', 
                        'State Code', 
                        'SGST', 
                        'SGST%', 
                        'CGST', 
                        'CGST%', 
                        'IGST', 
                        'IGST%', 
                        'CESS', 
                        'CESS%', 
                        'Item Tax', 
                        'Item Total', 
                        'Created By', 
                        'Modified By'
                    ];
                
                    fputcsv($file, $header);
                
                    // Write data rows
                    foreach ($data as $row) {
                        switch ($row['Payment_type']) {
                            case '1':
                                $paymenttype = "Cash";
                                $paymentmode = "Cash";
                                break;
                            case '2':
                                $paymenttype = "Card";
                                $paymentmode = "Card";
                                break;
                            case '3':
                                $paymenttype = "UPI";
                                $paymentmode = "Bank";
                                break;
                            case '4':
                                $paymenttype = "Bank Transfer";
                                $paymentmode = "Bank";
                                break;
                            case '5':
                                $paymenttype = "Cheque";
                                $paymentmode = "Cheque";
                                break;
                            default:
                                $paymenttype = "N/A";
                                $paymentmode = "N/A";
                        }
                
                        $statusMap = [
                            "1" => "New",
                            "2" => "Confirmed",
                            "3" => "Dispatched",
                            "4" => "Delivered",
                            "5" => "Cancelled",
                            "6" => "Completed"
                        ];
                        $label = $statusMap[$row['oAction_status']] ?? "Unknown";
                
                        $statusMap1 = [
                            "1" => "In-store",
                            "2" => "Online"
                        ];
                        $label1 = $statusMap1[$row['oStore_status']] ?? "Unknown";
                
                        $total = $row['iSelling_price'] * $row['iQty'];
                        $sgst_percent = 2.5;
                        $cgst_percent = 2.5;
                        $igst_percent = 5.0;
                        $sgst = $total * ($sgst_percent / 100);
                        $cgst = $total * ($cgst_percent / 100);
                        $igst = $total * ($igst_percent / 100);
                
                        fputcsv($file, [
                            $row['order_no'],              
                            $row['order_date'], 
                            $label,
                            $label1,
                            $row['invoice_no'],
                            $row['Created_date'], 
                            $row['displayname'],
                            $row['phoneno'],
                            '', 
                            $row['iSelling_price'],            
                            $row['Shipping'],              
                            '0.0', 
                            '0.0',                
                            $row['Coupon_amount'],                
                            $row['Coupon_code'],               
                            $row['Roundoff'],              
                            $row['Discount'],
                            '0.0',            
                            $row['oTax'], 
                            '0',   
                            '',
                            $row['due_amount'],
                            $row['oGrand_total'],
                            $row['Delivery_partner'],
                            $paymenttype,  
                            '',
                            '', 
                            '',
                            '',
                            '',
                            $row['displayname'],
                            $row['phoneno'],
                            $row['address'],
                            '',
                            $row['city'],
                            $row['state'],
                            $row['pincode'],                    
                            '-',                   
                            '-',        
                            $row['Deliveryby'],               
                            $row['Tracking_id'], 
                            $row['Product_name'],
                            $row['SKU'],
                            $row['iSelling_price'],
                            $row['iQty'],            
                            $row['HSN'],
                            $row['State'],
                            '', 
                            $sgst,
                            $cgst,
                            $igst,
                            $sgst,
                            $cgst,
                            $igst, 
                            '0.0',
                            '0.0',
                            $row['iTax'],
                            $total,
                            $row['oCreated_id'],
                            $row['oEditor_id'] 
                        ]);
                    }
                
                fclose($file);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                          VALUES ('$reportNo','Order and Order Item Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                } elseif ($reportFormat == "pdf") {
                $filePath = 'reports/order_order_item_report_' . time() . '.pdf';
                
                // Create a new PDF document
                $pdf = new FPDF('L', 'mm', array(2720, 1200));
                
                $pdf->AddPage();
                $pdf->SetFont('Arial', 'B', 12);
                
                // Table headers
                $headers = [
                    'Order Id', 
                    'Order Date', 
                    'Order Status', 
                    'Type', 
                    'Invoice Id', 
                    'Invoice Date', 
                    'Customer Name', 
                    'Customer Mobile',
                    'Cancel Reason', 
                    'Sale Price', 
                    'Shipping Charge', 
                    'Payment Charge', 
                    'Packaging Charge', 
                    'Coupon Discount',
                    'Coupon Code', 
                    'Round Off',
                    'Discount', 
                    'Payment Discount', 
                    'Tax Amount', 
                    'Earn Points', 
                    'Redeem Points', 
                    'Due Amount', 
                    'Total Amount', 
                    'Delivery Mode', 
                    'Payment Mode', 
                    'Express Delivery', 
                    'Delivery Slot', 
                    'Delivery Start At', 
                    'Delivery End At',
                    'Delivery Tracking Id', 
                    'Contact Name', 
                    'Contact Mobile', 
                    'Street1', 
                    'Street2', 
                    'City', 
                    'State',
                    'Pincode', 
                    'UTM Id', 
                    'UTM Campaign', 
                    'Delivery Partner Name', 
                    'Delivery Name', 
                    'Item Name', 
                    'Item Sku', 
                    'Item Price', 
                    'Item Qty', 
                    'HSN', 
                    'State', 
                    'State Code', 
                    'SGST', 
                    'SGST%', 
                    'CGST', 
                    'CGST%', 
                    'IGST', 
                    'IGST%', 
                    'CESS', 
                    'CESS%', 
                    'Item Tax', 
                    'Item Total', 
                    'Created By', 
                    'Modified By'
                ];
                
                
                // Set column widths
                $colWidths = array_fill(0, count($headers), 45); // Adjust column widths as needed
                $rowHeight = 8;
                
                // Print header row
                foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                
                // Print data rows
                foreach ($data as $row) {
                    switch ($row['Payment_type']) {
                        case '1':
                            $paymenttype = "Cash";
                            $paymentmode = "Cash";
                            break;
                        case '2':
                            $paymenttype = "Card";
                            $paymentmode = "Card";
                            break;
                        case '3':
                            $paymenttype = "UPI";
                            $paymentmode = "Bank";
                            break;
                        case '4':
                            $paymenttype = "Bank Transfer";
                            $paymentmode = "Bank";
                            break;
                        case '5':
                            $paymenttype = "Cheque";
                            $paymentmode = "Cheque";
                            break;
                        default:
                            $paymenttype = "N/A";
                            $paymentmode = "N/A";
                    }
                
                    $statusMap = [
                        "1" => "New",
                        "2" => "Confirmed",
                        "3" => "Dispatched",
                        "4" => "Delivered",
                        "5" => "Cancelled",
                        "6" => "Completed"
                    ];
                    $label = $statusMap[$row['oAction_status']] ?? "Unknown";
                
                    $statusMap1 = [
                        "1" => "In-store",
                        "2" => "Online"
                    ];
                    $label1 = $statusMap1[$row['oStore_status']] ?? "Unknown";
                
                    $total = $row['iSelling_price'] * $row['iQty'];
                    $sgst_percent = 2.5;
                    $cgst_percent = 2.5;
                    $igst_percent = 5.0;
                    $sgst = $total * ($sgst_percent / 100);
                    $cgst = $total * ($cgst_percent / 100);
                    $igst = $total * ($igst_percent / 100);
                $values = [
                    $row['order_no'],              
                    $row['order_date'], 
                    $label,
                    $label1,
                    $row['invoice_no'],
                    $row['Created_date'], 
                    $row['displayname'],
                    $row['phoneno'],
                    '', 
                    $row['iSelling_price'],            
                    $row['Shipping'],              
                    '0.0', 
                    '0.0',                
                    $row['Coupon_amount'],                
                    $row['Coupon_code'],               
                    $row['Roundoff'],              
                    $row['Discount'],
                    '0.0',            
                    $row['oTax'], 
                    '0',   
                    '',
                    $row['due_amount'],
                    $row['oGrand_total'],
                    $row['Delivery_partner'],
                    $paymenttype,  
                    '',
                    '', 
                    '',
                    '',
                    '',
                    $row['displayname'],
                    $row['phoneno'],
                    $row['address'],
                    '',
                    $row['city'],
                    $row['state'],
                    $row['pincode'],                    
                    '-',                   
                    '-',        
                    $row['Deliveryby'],               
                    $row['Tracking_id'], 
                    $row['Product_name'],
                    $row['SKU'],
                    $row['iSelling_price'],
                    $row['iQty'],            
                    $row['HSN'],
                    $row['State'],
                    '', 
                    $sgst,
                    $cgst,
                    $igst,
                    $sgst,
                    $cgst,
                    $igst, 
                    '0.0',
                    '0.0',
                    $row['iTax'],
                    $total,
                    $row['oCreated_id'],
                    $row['oEditor_id']
                ];
                
                foreach ($values as $index => $value) {
                  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                }
                
                // Save the PDF file
                $pdf->Output('F', $filePath);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                         VALUES ('$reportNo','Order and Order Item Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                } else {
                echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                }
                
                }
            }
            ?>