<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                        'Order ID', 'Order Status',
                         'Order Date', 'Order Amount', 
                         'Order Type', 'Invoice ID',
                         'Invoice Date', 'Customer Name',
                          'Customer Mobile', 'Payment Amount',
                          'Payment Method', 'Payment Mode',
                           'Gateway', 'Gateway Payment Id',
                            'Payment Date', 'Settle Date', 
                            'Settled Amount', 'Reference ID',
                             'Notes'
                        ];
                    }
                    $query = "SELECT 
                    o.Order_id,
                    o.order_no,
                    o.Created_date,
                    o.Grand_total,
                    o.Action_status,
                    o.Store_status,
                    i.invoice_id,
                    i.invoice_no,
                    i.created_date,
                    u.displayname AS customer_name,
                    u.phoneno AS customer_mobile,
                    p.Payment_amount,
                    p.Payment_type,
                    p.Payment_date,
                    p.Reference_id,
                    p.note
              
            FROM 
                orders o
            LEFT JOIN 
                invoice i 
            ON 
                o.Invoice_id = i.invoice_id
            LEFT JOIN 
                    payment p 
                ON 
                    o.Order_id = p.Order_id
            LEFT JOIN 
                customer u
            ON 
                o.User_id = u.id 
            WHERE 
                o.Delete_status = 0
                AND p.Delete_status = 0";
            
            
            if ($duration == "Today") {
                $query .= " AND DATE(o.Created_date) = CURDATE()";
            } elseif ($duration == "Yesterday") {
                $query .= " AND DATE(o.Created_date) = CURDATE() - INTERVAL 1 DAY";
            } elseif ($duration == "Last Week") {
                $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
            } elseif ($duration == "Last Month") {
                $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
            } elseif ($duration == "Custom" && $startDate && $endDate) {
                $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
            }
            // Perform the query using MySQLi
            $result = $conn->query($query);
            $data = [];
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $data[] = $row;
                }
            }
            
            // Generate the CSV file
            if ($reportFormat == "Xlsx") {
            $filePath = 'reports/payment_report_' . time() . '.csv';
            $file = fopen($filePath, 'w');
            
            // Write the header row
            $header = [];

            // Dynamically add columns to the header using if (or switch for different scenarios)
            if (in_array('Order ID', $columns)) $header[] = 'Order Id';
            if (in_array('Order Status', $columns)) $header[] = 'Order Status';
            if (in_array('Order Date', $columns)) $header[] = 'Order Date';
            if (in_array('Order Amount', $columns)) $header[] = 'Order Amount';
            if (in_array('Order Type', $columns)) $header[] = 'Order Type';
            if (in_array('Invoice ID', $columns)) $header[] = 'Invoice Id';
            if (in_array('Invoice Date', $columns)) $header[] = 'Invoice Date';
            if (in_array('Customer Name', $columns)) $header[] = 'Customer Name';
            if (in_array('Customer Mobile', $columns)) $header[] = 'Customer Mobile';
            if (in_array('Payment Amount', $columns)) $header[] = 'Payment Amount';
            if (in_array('Payment Method', $columns)) $header[] = 'Payment Method';
            if (in_array('Payment Mode', $columns)) $header[] = 'Payment Mode';
            if (in_array('Gateway', $columns)) $header[] = 'Gateway';
            if (in_array('Gateway Payment Id', $columns)) $header[] = 'Gateway Payment Id';
            if (in_array('Payment Date', $columns)) $header[] = 'Payment Date';
            if (in_array('Settle Date', $columns)) $header[] = 'Settle Date';
            if (in_array('Settled Amount', $columns)) $header[] = 'Settled Amount';
            if (in_array('Reference ID', $columns)) $header[] = 'Reference Id';
            if (in_array('Notes', $columns)) $header[] = 'Notes';
            
            // Write the header to the CSV file
            fputcsv($file, $header);
            
             
            
            // Write data rows
            foreach ($data as $row) {
                switch ($row['Payment_type']) {
                    case '1':
                        $paymenttype = "Cash";
                        $paymentmode = "Cash";
                        break;
                    case '2':
                        $paymenttype = "Card";
                        $paymentmode = "Card";
                        break;
                    case '3':
                        $paymenttype = "UPI";
                        $paymentmode = "Bank";
                        break;
                    case '4':
                        $paymenttype = "Bank Transfer";
                        $paymentmode = "Bank";
                        break;
                    case '5':
                        $paymenttype = "Cheque";
                        $paymentmode = "Cheque";
                        break;
                    default:
                        $paymenttype = "N/A";
                        $paymentmode = "N/A";
                }
                $statusMap = [
                    "1" => "New",
                    "2" => "Confirmed",
                    "3" => "Dispatched",
                    "4" => "Delivered",
                    "5" => "Cancelled",
                    "6" => "Completed"
                ];
                $label = $statusMap[$row['Action_status']] ?? "Unknown";
                $statusMap1 = [
                    "1" =>"instore",
                    "2" => "online"
                ];
                $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";
            
                foreach ($data as $row) {
                    $rowData = [];
                
                    // Dynamically add values to rowData based on header inclusion
                    if (in_array('Order ID', $columns)) $rowData[] = $row['order_no'];
                    if (in_array('Order Status', $columns)) $rowData[] = $label;
                    if (in_array('Order Date', $columns)) $rowData[] = $row['Created_date'];
                    if (in_array('Order Amount', $columns)) $rowData[] = $row['Grand_total'];
                    if (in_array('Order Type', $columns)) $rowData[] = $label1; // Placeholder for 'Order Type'
                    if (in_array('Invoice ID', $columns)) $rowData[] = $row['invoice_no'];
                    if (in_array('Invoice Date', $columns)) $rowData[] = $row['created_date'];
                    if (in_array('Customer Name', $columns)) $rowData[] = $row['customer_name'];
                    if (in_array('Customer Mobile', $columns)) $rowData[] = $row['customer_mobile'];
                    if (in_array('Payment Amount', $columns)) $rowData[] = $row['Payment_amount'];
                    if (in_array('Payment Method', $columns)) $rowData[] = $paymenttype;
                    if (in_array('Payment Mode', $columns)) $rowData[] = $paymentmode;
                    if (in_array('Gateway', $columns)) $rowData[] = 'razorpay'; // Static value for 'Gateway'
                    if (in_array('Gateway Payment Id', $columns)) $rowData[] = ''; // Placeholder for 'Gateway Payment Id'
                    if (in_array('Payment Date', $columns)) $rowData[] = $row['Payment_date'];
                    if (in_array('Settle Date', $columns)) $rowData[] = $row['Payment_date']; // Assuming same value for 'Settle Date'
                    if (in_array('Settled Amount', $columns)) $rowData[] = $row['Payment_amount'];
                    if (in_array('Reference ID', $columns)) $rowData[] = $row['Reference_id'];
                    if (in_array('Notes', $columns)) $rowData[] = $row['note'];
                
                    // Write the row to the CSV file
                    fputcsv($file, $rowData);
                }
            }
                // Close the file
                fclose($file);
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                      VALUES ('$reportNo','Payment Report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);
            
            echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
            } elseif ($reportFormat == "pdf") {
            $filePath = 'reports/payment_report_' . time() . '.pdf';
            
            // Create a new PDF document
            $pdf = new FPDF('L', 'mm', array(820, 400));
            
            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 12);
            
            // Table headers
            $headers = [
                'Order Id',
                'Order Status',
                'Order Date',
                'Order Amount',
                'Order Type',
                'Invoice Id',
                'Invoice Date',
                'Customer Name',
                'Customer Mobile',
                'Payment Amount',
                'Payment Method',
                'Payment Mode',
                'Gateway',
                'Gateway Payment Id',
                'Payment Date',
                'Settle Date',
                'Settled Amount',
                'Reference Id',
                'Notes'
            ];
            
            
            // Set column widths
            $colWidths = array_fill(0, count($headers), 42); // Adjust column widths as needed
            $rowHeight = 8;
            
            // Print header row
            foreach ($headers as $index => $header) {
            $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row
            
            // Print data rows
            foreach ($data as $row) {
                switch ($row['Payment_type']) {
                    case '1':
                        $paymenttype = "Cash";
                        $paymentmode = "Cash";
                        break;
                    case '2':
                        $paymenttype = "Card";
                        $paymentmode = "Card";
                        break;
                    case '3':
                        $paymenttype = "UPI";
                        $paymentmode = "Bank";
                        break;
                    case '4':
                        $paymenttype = "Bank Transfer";
                        $paymentmode = "Bank";
                        break;
                    case '5':
                        $paymenttype = "Cheque";
                        $paymentmode = "Cheque";
                        break;
                    default:
                        $paymenttype = "N/A";
                        $paymentmode = "N/A";
                }
                $statusMap = [
                    "1" => "New",
                    "2" => "Confirmed",
                    "3" => "Dispatched",
                    "4" => "Delivered",
                    "5" => "Cancelled",
                    "6" => "Completed"
                ];
                $label = $statusMap[$row['Action_status']] ?? "Unknown";
                $statusMap1 = [
                    "1" =>"instore",
                    "2" => "online"
                ];
                $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";
            $values = [
                $row['order_no'],                   
                $label,              
                $row['Created_date'],                 
                $row['Grand_total'],              
                $label1,                 
                $row['invoice_no'],                
                $row['created_date'],               
                $row['customer_name'],              
                $row['customer_mobile'],            
                $row['Payment_amount'],             
                $paymenttype,                      
                $paymentmode,                       
                'razorpay',                   
                '',        
                $row['Payment_date'],               
                $row['Payment_date'],                
                $row['Payment_amount'],            
                $row['Reference_id'],               
                $row['note'] 
            ];
            
            foreach ($values as $index => $value) {
              $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row
            }
            
            // Save the PDF file
            $pdf->Output('F', $filePath);
            
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                     VALUES ('$reportNo','Payment Report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);
            
            echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
            } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
            }
                }
            }
?>