<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;
                
                 if ($reportType == "Order Report") {
                 $query = "SELECT 
                    o.Order_id, 
                    o.Invoice_id, 
                    i.invoice_no,
                    i.created_date AS invoice_date, 
                    o.order_no, 
                    o.user_id, 
                    o.Created_date AS Order_Date, 
                    o.Due_date, 
                    o.Balance, 
                    o.Tax, 
                    o.Tax_percentage, 
                    o.Discount, 
                    o.Discount_percentage, 
                    o.Shipping, 
                    o.Roundoff, 
                    o.Coupon_code, 
                    o.Coupon_amount, 
                    o.Total_saving, 
                    o.Total_price, 
                    o.No_of_items, 
                    o.Delivery_partner, 
                    o.Deliveryby, 
                    o.Tracking_id, 
                    o.Delivery_date, 
                    o.Confirmed_date, 
                    o.Action_status, 
                    o.Total_discount, 
                    o.Grand_total, 
                    o.Payment_status, 
                    o.Store_status, 
                    o.Created_id, 
                    o.Editor_id,
                    u.Name AS Customer_Name, 
                    u.Phone AS Customer_Mobile, 
                    u.Address, 
                    u.City, 
                    u.State, 
                    u.Pincode
                FROM 
                    orders o
                LEFT JOIN 
                    invoice i 
                ON 
                    o.Invoice_id = i.invoice_id
                LEFT JOIN 
                    user_profile u 
                ON 
                    o.user_id = u.User_id
                WHERE 
                    o.Delete_status = 0";
            
            // Apply duration filters (last week, last month, etc.)
            if ($duration == "Last Week") {
            $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
            } elseif ($duration == "Last Month") {
            $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
            } elseif ($duration == "This Year") {
            $query .= " AND YEAR(o.Created_date) = YEAR(NOW())";
            } elseif ($duration == "Custom" && $startDate && $endDate) {
            $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
            }
            
            // Perform the query using MySQLi
            $result = $conn->query($query);
            $data = [];
            while ($row = $result->fetch_assoc()) {
            $data[] = $row;
            }
            
            // Generate the CSV file
            if ($reportFormat == "Xlsx") {
            $filePath = 'reports/order_report_' . time() . '.csv';
            $file = fopen($filePath, 'w');
            
            // Write the header row
            $header = [
                'Order Id',
                'Order Date',
                'Order Status',
                'Invoice Id',
                'Invoice Date',
                'Customer Name',
                'Customer Mobile',
                'Cancel Reason',
                'Sale Price',
                'Shipping Charge',
                'Packaging Charge',
                'Payment Charge',
                'Payment Discount',
                'Coupon Discount',
                'Coupon Code',
                'Round Off',
                'Discount',
                'Tax Amount',
                'Total Amount',
                'Earn Points',
                'Redeem Points',
                'Due Amount',
                'Delivery Mode',
                'Payment Mode',
                'Express Delivery',
                'Delivery Slot',
                'Delivery Start At',
                'Delivery End At',
                'Delivery Partner Name',
                'Delivery Tracking Id',
                'Contact Name',
                'Contact Mobile',
                'Street1',
                'Street2',
                'City',
                'State',
                'Pincode',
                'UTM Id',
                'UTM Campaign',
                'Created By',
                'Modified By'
            ];
            
            fputcsv($file, $header);
            
           
            foreach ($data as $row) {
                
                fputcsv($file, [
                    $row['order_no'],
                    $row['Order_Date'],
                    $row['Action_status'], 
                    $row['invoice_no'],
                    $row['invoice_date'], 
                    $row['Customer_Name'],
                    $row['Customer_Mobile'],
                    '', 
                    $row['Total_price'], 
                    $row['Shipping'], 
                    '', 
                    '', 
                    '', 
                    $row['Coupon_amount'], 
                    $row['Coupon_code'], 
                    $row['Roundoff'], 
                    $row['Discount'], 
                    $row['Tax'], 
                    $row['Grand_total'], 
                    '', 
                    '', 
                    $row['Balance'], 
                    '', 
                    '', 
                    '', 
                    '', 
                    $row['Delivery_date'], 
                    '', 
                    $row['Delivery_partner'], 
                    $row['Tracking_id'], 
                    $row['Customer_Name'],
                    $row['Customer_Mobile'],
                    $row['Address'], 
                    '', 
                    $row['City'],
                    $row['State'],
                    $row['Pincode'],
                    '', 
                    '', 
                    $row['Created_id'], 
                    $row['Editor_id'] 
                ]);
            }
            
            fclose($file);


            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports
        ";
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
                            VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
            $conn->query($insertQuery);

            echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
        } elseif ($reportFormat == "pdf") {
            $filePath = 'reports/order_report_' . time() . '.pdf';

            // Create a new PDF document
            $pdf = new FPDF('L', 'mm', array(1450, 700));

            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 12);
        
            // Table headers
            $headers = [
                'Order Id', 'Order Date', 'Order Status', 'Invoice Id', 'Invoice Date',
                'Customer Name', 'Customer Mobile', 'Cancel Reason', 'Sale Price',
                'Shipping Charge', 'Packaging Charge', 'Payment Charge', 'Payment Discount',
                'Coupon Discount', 'Coupon Code', 'Round Off', 'Discount', 'Tax Amount',
                'Total Amount', 'Earn Points', 'Redeem Points', 'Due Amount',
                'Delivery Mode', 'Payment Mode', 'Express Delivery', 'Delivery Slot',
                'Delivery Start At', 'Delivery End At', 'Delivery Partner Name',
                'Delivery Tracking Id', 'Contact Name', 'Contact Mobile', 'Street1',
                'Street2', 'City', 'State', 'Pincode', 'UTM Id', 'UTM Campaign',
                'Created By', 'Modified By'
            ];
        
            // Set column widths
            $colWidths = array_fill(0, count($headers), 35); // Adjust column widths as needed
            $rowHeight = 8;
        
            // Print header row
            foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row
        
            // Print data rows
            foreach ($data as $row) {
                $values = [
                    $row['order_no'], $row['Order_Date'], $row['Action_status'], $row['invoice_no'],
                    $row['invoice_date'], $row['Customer_Name'], $row['Customer_Mobile'], '',
                    $row['Total_price'], $row['Shipping'], '', '', '', $row['Coupon_amount'],
                    $row['Coupon_code'], $row['Roundoff'], $row['Discount'], $row['Tax'],
                    $row['Grand_total'], '', '', $row['Balance'], '', '', '', '',
                    $row['Delivery_date'], '', $row['Delivery_partner'], $row['Tracking_id'],
                    $row['Customer_Name'], $row['Customer_Mobile'], $row['Address'], '', $row['City'],
                    $row['State'], $row['Pincode'], '', '', $row['Created_id'], $row['Editor_id']
                ];
        
                foreach ($values as $index => $value) {
                    $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
            }
        
            // Save the PDF file

            $pdf->Output('F', $filePath);
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports
        ";
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
                           VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
            $conn->query($insertQuery);
        
            echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
        }
        
    }

elseif($reportType == "Invoice Report") {  
      $query = "SELECT 
    i.invoice_id, 
    i.invoice_no, 
    o.order_no, 
    i.created_date AS Created_at, 
    i.Created_id, 
    i.Editor_id, 
    i.user_id, 
    i.created_date AS invoice_date, 
    i.Grand_total,
    i.Total_price,
    i.Total_discount,
    i.Tax,
    i.Roundoff,
    i.Balance,
    i.Shipping,
    i.Discount,
    i.Coupon_code,
    i.Coupon_amount,
    i.Payment_status,
    i.Due_date,
    u.Name AS Customer_Name, 
    u.Phone AS Customer_Mobile, 
    u.Address, 
    u.City, 
    u.State, 
    u.Pincode
FROM 
     invoice i
LEFT JOIN 
    orders o
ON 
    i.invoice_id = o.Invoice_id
LEFT JOIN 
    user_profile u 
ON 
    i.user_id = u.User_id
WHERE 
    o.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
$query .= " AND i.created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
$query .= " AND i.created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
$query .= " AND YEAR(i.created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
$query .= " AND i.created_date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
while ($row = $result->fetch_assoc()) {
$data[] = $row;
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/invoice_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
    'Invoice Id',
    'Invoice Date',
    'Create Date',
    'Order Id',
    'Customer Name',
    'Customer Mobile',
    'Coupon Code',
    'Sale Price',
    'Shipping Charge',
    'Packaging Charge',
    'Payment Charge',
    'Payment Discount',
    'Coupon Discount',
    'Round Off',
    'Discount',
    'Tax Amount',
    'Total Amount',
    'Due Amount',
    'Created By',
    'Modified By'
];


fputcsv($file, $header);

// Write data rows
foreach ($data as $row) {
// Ensure values are properly aligned to headers
fputcsv($file, [
    $row['invoice_no'], 
    $row['invoice_date'], 
    $row['Created_at'], 
    $row['order_no'], 
    $row['Customer_Name'], 
    $row['Customer_Mobile'],
    $row['Coupon_code'], 
    $row['Total_price'], 
    $row['Shipping'], 
    '', 
    '', 
    '', 
    $row['Coupon_amount'], 
    $row['Roundoff'], 
    $row['Discount'], 
    $row['Tax'], 
    $row['Grand_total'], 
    $row['Balance'], 
    $row['Created_id'], 
    $row['Editor_id'] 
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
            VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/invoice_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(720, 700));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Invoice Id',
    'Invoice Date',
    'Create Date',
    'Order Id',
    'Customer Name',
    'Customer Mobile',
    'Coupon Code',
    'Sale Price',
    'Shipping Charge',
    'Packaging Charge',
    'Payment Charge',
    'Payment Discount',
    'Coupon Discount',
    'Round Off',
    'Discount',
    'Tax Amount',
    'Total Amount',
    'Due Amount',
    'Created By',
    'Modified By'
];

// Set column widths
$colWidths = array_fill(0, count($headers), 35); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
$values = [
    $row['invoice_no'], 
    $row['invoice_date'], 
    $row['Created_at'], 
    $row['order_no'], 
    $row['Customer_Name'], 
    $row['Customer_Mobile'],
    $row['Coupon_code'], 
    $row['Total_price'], 
    $row['Shipping'], 
    '', 
    '', 
    '', 
    $row['Coupon_amount'], 
    $row['Roundoff'], 
    $row['Discount'], 
    $row['Tax'], 
    $row['Grand_total'], 
    $row['Balance'], 
    $row['Created_id'], 
    $row['Editor_id'] 
];

foreach ($values as $index => $value) {
    $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
           VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "Customer Report") {  
    $query = "SELECT 
    u.Name AS Customer_Name, 
    u.Phone AS Customer_Mobile, 
    u.Address, 
    u.City, 
    u.State, 
    u.Pincode,
    u.Email,
    u.gstin,
    u.Role,
    u.Created_date AS Create_date,
    SUM(o.Balance) AS balance_amount
FROM 
    user_profile u
LEFT JOIN 
    orders o
ON 
    u.User_id = o.User_id
WHERE 
    o.Delete_status = 0
    AND u.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND u.Created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND u.Created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(u.Created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND u.Created_date BETWEEN '$startDate' AND '$endDate'";
}

// Add GROUP BY clause
$query .= " GROUP BY 
    u.Name, u.Phone, u.Address, u.City, u.State, u.Pincode, u.Email, u.gstin, u.Created_date";

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/customer_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
    'Customer Name',
    'Customer Mobile',
    'Balance Amount',
    'GSTIN',
    'Email',
    'Tag',
    'Type',
    'Referral Code',
    'Create Date'
];



fputcsv($file, $header);

 

// Write data rows
foreach ($data as $row) {
// Ensure values are properly aligned to headers
$role = ($row['Role'] == 1) ? 'Admin' : (($row['Role'] == 2) ? 'Customer' : 'Other');

fputcsv($file, [
  $row['Customer_Name'],
  $row['Customer_Mobile'],
  $row['balance_amount'],
  $row['gstin'],
  $row['Email'],    
  $role,   
  $role, 
  '',  
  $row['Create_date']
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/customer_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(485, 210));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Customer Name',
    'Customer Mobile',
    'Balance Amount',
    'GSTIN',
    'Email',
    'Tag',
    'Type',
    'Referral Code',
    'Create Date'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 52); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
    $balance_amount = $row['balance_amount']; // Original value
if (is_numeric($balance_amount)) {
    $balance_amount = number_format((float)$balance_amount, 2, '.', ''); // Format to preserve precision
}
    $role = ($row['Role'] == 1) ? 'Admin' : (($row['Role'] == 2) ? 'Customer' : 'Other');
$values = [
    $row['Customer_Name'],
  $row['Customer_Mobile'],
  $balance_amount,
  $row['gstin'],
  $row['Email'],    
  $role,   
  $role, 
  '',  
  $row['Create_date'] 
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif ($reportType == "Order Item Report") {
    $query = "
    SELECT 
        o.Order_id AS orderid, 
        o.Invoice_id, 
        i.invoice_no AS invoiceno,
        i.created_date AS invoicedate, 
        o.order_no, 
        o.user_id, 
        o.Created_date AS createdate, 
        o.Total_price, 
        o.Action_status, 
        o.Grand_total, 
        o.Store_status,
        o.Payment_status,  
        u.Name AS customer_name, 
        u.Phone AS customer_mobile, 
        u.Address, 
        u.City, 
        u.State, 
        u.Pincode,
        p.Payment_type,
        pd.Product_name AS item_name, 
        pd.SKU AS sku, 
        pd.HSN, 
        od.Selling_price AS price, 
        od.qty AS quantity,
        od.Product_total
    FROM 
        orders o
    LEFT JOIN 
        invoice i 
    ON 
        o.Invoice_id = i.invoice_id
    LEFT JOIN 
        order_data od 
    ON 
        o.Order_id = od.Order_id
    LEFT JOIN
        product pd 
    ON 
        od.Product_id = pd.Product_id
    LEFT JOIN 
        payment p 
    ON 
        o.Order_id = p.Order_id
    LEFT JOIN 
        user_profile u 
    ON 
        o.user_id = u.User_id
    WHERE 
        o.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(o.Created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
}

// Ensure no unnecessary GROUP BY clause
$query .= " ORDER BY o.Order_id";

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
    $filePath = 'reports/order_item_report_' . time() . '.csv';
    $file = fopen($filePath, 'w');

    if (!$file) {
        die(json_encode(['status' => 'error', 'message' => 'Unable to create CSV file.']));
    }

    // Write the header row
    $header = [
        'Order Id', 'Order Status', 'Type', 'Delivery Mode', 'Payment Mode', 'Order Date',
        'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Item Name',
        'Item Sku', 'Item Price', 'Item Qty', 'HSN', 'State', 'State Code', 'SGST', 'SGST%',
        'CGST', 'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 'Item Tax', 'Item Total'
    ];

    fputcsv($file, $header);

    // Write data rows
    foreach ($data as $row) {
        // Handle Payment Type
        switch ($row['Payment_type']) {
            case '1':
                $paymenttype = "Cash";
                $paymentmode = "Cash";
                break;
            case '2':
                $paymenttype = "Card";
                $paymentmode = "Card";
                break;
            case '3':
                $paymenttype = "UPI";
                $paymentmode = "Bank";
                break;
            case '4':
                $paymenttype = "Bank Transfer";
                $paymentmode = "Bank";
                break;
            case '5':
                $paymenttype = "Cheque";
                $paymentmode = "Cheque";
                break;
            default:
                $paymenttype = "N/A";
                $paymentmode = "N/A";
        }

        // Handle Action Status
        $statusMap = [
            "1" => "New",
            "2" => "Confirmed",
            "3" => "Dispatched",
            "4" => "Delivered",
            "5" => "Cancelled",
            "6" => "Completed"
        ];
        $label = $statusMap[$row['Action_status']] ?? "Unknown";
        
        $statusMap1 = [
            "1" =>"instore",
            "2" => "online"
        ];
        $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";

        // Tax Calculations
        $total = $row['Product_total'];
        $sgst_percent = 2.5;
        $cgst_percent = 2.5;
        $igst_percent = 5.0;
        $sgst = $total * ($sgst_percent / 100);
        $cgst = $total * ($cgst_percent / 100);
        $igst = $total * ($igst_percent / 100);
        $itemtotal = $total + $sgst + $cgst + $igst;

        // Write row to CSV
        fputcsv($file, [
            $row['order_no'], 
            $label, 
            $label1, // Placeholder for 'Type'
            '', // Placeholder for 'Delivery Mode'
            $paymenttype, 
            $row['createdate'], 
            $row['invoiceno'], 
            $row['invoicedate'], 
            $row['customer_name'], 
            $row['customer_mobile'], 
            $row['item_name'], 
            $row['sku'], 
            $row['price'], 
            $row['quantity'], 
            $row['HSN'],
            $row['State'], 
            '', // Placeholder for 'State Code'
            $sgst, 
            $sgst_percent, 
            $cgst, 
            $cgst_percent, 
            $igst, 
            $igst_percent, 
            0, // Placeholder for 'CESS'
            0, // Placeholder for 'CESS%'
            0, // Placeholder for 'Item Tax'
            $itemtotal
        ]);
    }

    fclose($file);

    // Insert report details into the database
    $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
    $report_no_result = $conn->query($report_no_query);
    $max_id = $report_no_result->fetch_assoc()['max_id'] ?? 0;
    $reportNo = 'REP_' . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);
    $durationText = $duration ?? 'N/A';
    $insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
                    VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
    $conn->query($insertQuery);

    echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} 
 elseif ($reportFormat == "pdf") {
$filePath = 'reports/order_item_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(1100, 700));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
 'Order Id', 'Order Status', 'Type', 'Delivery Mode', 'Payment Mode', 'Order Date',
        'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Item Name',
        'Item Sku', 'Item Price', 'Item Qty', 'HSN', 'State', 'State Code', 'SGST', 'SGST%',
        'CGST', 'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 'Item Tax', 'Item Total'
];

// Set column widths
$colWidths = array_fill(0, count($headers), 40); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
   $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
        // Handle Payment Type
        switch ($row['Payment_type']) {
            case '1':
                $paymenttype = "Cash";
                $paymentmode = "Cash";
                break;
            case '2':
                $paymenttype = "Card";
                $paymentmode = "Card";
                break;
            case '3':
                $paymenttype = "UPI";
                $paymentmode = "Bank";
                break;
            case '4':
                $paymenttype = "Bank Transfer";
                $paymentmode = "Bank";
                break;
            case '5':
                $paymenttype = "Cheque";
                $paymentmode = "Cheque";
                break;
            default:
                $paymenttype = "N/A";
                $paymentmode = "N/A";
        }

        // Handle Action Status
        $statusMap = [
            "1" => "New",
            "2" => "Confirmed",
            "3" => "Dispatched",
            "4" => "Delivered",
            "5" => "Cancelled",
            "6" => "Completed"
        ];
        $label = $statusMap[$row['Action_status']] ?? "Unknown";
        $statusMap1 = [
            "1" =>"instore",
            "2" => "online"
        ];
        $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";

        // Tax Calculations
        $total = $row['Product_total'];
        $sgst_percent = 2.5;
        $cgst_percent = 2.5;
        $igst_percent = 5.0;
        $sgst = $total * ($sgst_percent / 100);
        $cgst = $total * ($cgst_percent / 100);
        $igst = $total * ($igst_percent / 100);
        $itemtotal = $total + $sgst + $cgst + $igst;
   $values = [
    $row['order_no'], 
            $label, 
            $label1, // Placeholder for 'Type'
            '', // Placeholder for 'Delivery Mode'
            $paymenttype, 
            $row['createdate'], 
            $row['invoiceno'], 
            $row['invoicedate'], 
            $row['customer_name'], 
            $row['customer_mobile'], 
            $row['item_name'], 
            $row['sku'], 
            $row['price'], 
            $row['quantity'], 
            $row['HSN'],
            $row['State'], 
            '', // Placeholder for 'State Code'
            $sgst, 
            $sgst_percent, 
            $cgst, 
            $cgst_percent, 
            $igst, 
            $igst_percent, 
            0, // Placeholder for 'CESS'
            0, // Placeholder for 'CESS%'
            0, // Placeholder for 'Item Tax'
            $itemtotal
        ];

   foreach ($values as $index => $value) {
       $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
   }
   $pdf->Ln(); // Move to the next row
}

// Save the PDF file

$pdf->Output('F', $filePath);
$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports
";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
              VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "Payment Report") {  
    $query = "SELECT 
        o.Order_id,
        o.order_no,
        o.Created_date,
        o.Grand_total,
        o.Action_status,
        o.Store_status,
        i.invoice_id,
        i.invoice_no,
        i.created_date,
        u.Name AS customer_name,
        u.Phone AS customer_mobile,
        p.Payment_amount,
        p.Payment_type,
        p.Payment_date,
        p.Reference_id,
        p.note
  
FROM 
    orders o
LEFT JOIN 
    invoice i 
ON 
    o.Invoice_id = i.invoice_id
LEFT JOIN 
        payment p 
    ON 
        o.Order_id = p.Order_id
LEFT JOIN 
    user_profile u
ON 
    o.User_id = u.User_id 
WHERE 
    o.Delete_status = 0
    AND p.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(o.Created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/payment_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
    'Order Id',
    'Order Status',
    'Order Date',
    'Order Amount',
    'Order Type',
    'Invoice Id',
    'Invoice Date',
    'Customer Name',
    'Customer Mobile',
    'Payment Amount',
    'Payment Method',
    'Payment Mode',
    'Gateway',
    'Gateway Payment Id',
    'Payment Date',
    'Settle Date',
    'Settled Amount',
    'Reference Id',
    'Notes'
];


fputcsv($file, $header);

 

// Write data rows
foreach ($data as $row) {
    switch ($row['Payment_type']) {
        case '1':
            $paymenttype = "Cash";
            $paymentmode = "Cash";
            break;
        case '2':
            $paymenttype = "Card";
            $paymentmode = "Card";
            break;
        case '3':
            $paymenttype = "UPI";
            $paymentmode = "Bank";
            break;
        case '4':
            $paymenttype = "Bank Transfer";
            $paymentmode = "Bank";
            break;
        case '5':
            $paymenttype = "Cheque";
            $paymentmode = "Cheque";
            break;
        default:
            $paymenttype = "N/A";
            $paymentmode = "N/A";
    }
    $statusMap = [
        "1" => "New",
        "2" => "Confirmed",
        "3" => "Dispatched",
        "4" => "Delivered",
        "5" => "Cancelled",
        "6" => "Completed"
    ];
    $label = $statusMap[$row['Action_status']] ?? "Unknown";
    $statusMap1 = [
        "1" =>"instore",
        "2" => "online"
    ];
    $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";

fputcsv($file, [
    $row['order_no'],                   
    $label,              
    $row['Created_date'],                 
    $row['Grand_total'],              
    $label1,                 
    $row['invoice_no'],                
    $row['created_date'],               
    $row['customer_name'],              
    $row['customer_mobile'],            
    $row['Payment_amount'],             
    $paymenttype,                      
    $paymentmode,                       
    'razorpay',                   
    '',        
    $row['Payment_date'],               
    $row['Payment_date'],                
    $row['Payment_amount'],            
    $row['Reference_id'],               
    $row['note'] 
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/payment_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(820, 400));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Order Id',
    'Order Status',
    'Order Date',
    'Order Amount',
    'Order Type',
    'Invoice Id',
    'Invoice Date',
    'Customer Name',
    'Customer Mobile',
    'Payment Amount',
    'Payment Method',
    'Payment Mode',
    'Gateway',
    'Gateway Payment Id',
    'Payment Date',
    'Settle Date',
    'Settled Amount',
    'Reference Id',
    'Notes'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 42); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
    switch ($row['Payment_type']) {
        case '1':
            $paymenttype = "Cash";
            $paymentmode = "Cash";
            break;
        case '2':
            $paymenttype = "Card";
            $paymentmode = "Card";
            break;
        case '3':
            $paymenttype = "UPI";
            $paymentmode = "Bank";
            break;
        case '4':
            $paymenttype = "Bank Transfer";
            $paymentmode = "Bank";
            break;
        case '5':
            $paymenttype = "Cheque";
            $paymentmode = "Cheque";
            break;
        default:
            $paymenttype = "N/A";
            $paymentmode = "N/A";
    }
    $statusMap = [
        "1" => "New",
        "2" => "Confirmed",
        "3" => "Dispatched",
        "4" => "Delivered",
        "5" => "Cancelled",
        "6" => "Completed"
    ];
    $label = $statusMap[$row['Action_status']] ?? "Unknown";
    $statusMap1 = [
        "1" =>"instore",
        "2" => "online"
    ];
    $label1 = $statusMap1[$row['Store_status']] ?? "Unknown";
$values = [
    $row['order_no'],                   
    $label,              
    $row['Created_date'],                 
    $row['Grand_total'],              
    $label1,                 
    $row['invoice_no'],                
    $row['created_date'],               
    $row['customer_name'],              
    $row['customer_mobile'],            
    $row['Payment_amount'],             
    $paymenttype,                      
    $paymentmode,                       
    'razorpay',                   
    '',        
    $row['Payment_date'],               
    $row['Payment_date'],                
    $row['Payment_amount'],            
    $row['Reference_id'],               
    $row['note'] 
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "GST Report") {  
    $query = "SELECT 
    i.invoice_id, 
    i.invoice_no, 
    o.Order_id, 
    o.order_no, 
    i.created_date AS invoice_date, 
    u.Name AS Customer_Name, 
    u.Phone AS Customer_Mobile, 
    pd.Product_name AS Product_Name, 
    pd.HSN, 
    id.qty, 
    id.Selling_price
FROM 
    invoice i
LEFT JOIN 
    invoice_data id
ON 
    i.invoice_id = id.invoice_id
LEFT JOIN 
    orders o
ON 
    o.Invoice_id = i.invoice_id
LEFT JOIN 
    product pd 
ON 
    id.Product_id = pd.Product_id
LEFT JOIN 
    user_profile u 
ON 
    i.user_id = u.User_id
WHERE 
    i.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND i.created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND i.created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(i.created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND i.created_date BETWEEN '$startDate' AND '$endDate'";
}

$query .= " ORDER BY i.invoice_id";


// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
while ($row = $result->fetch_assoc()) {
$data[] = $row;
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/GST_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
 'Invoice Id', 
 'Invoice Date', 
 'Customer Name', 
 'Customer Mobile', 
 'Item Name', 
 'HSN', 
 'Quantity', 
 'Price Per Unit', 
 'SGST', 
 'SGST%', 
 'CGST', 
 'CGST%', 
 'IGST', 
 'IGST%', 
 'CESS', 
 'CESS%', 
 'Item Total'
];


fputcsv($file, $header);

// Write data rows
foreach ($data as $row) {
// Ensure values are properly aligned to headers
$total=$row['Selling_price']*$row['qty'];
$sgst_percent = 2.5;
$cgst_percent = 2.5;
$igst_percent = 5.0;
$sgst = $total * ($sgst_percent / 100);
$cgst = $total * ($cgst_percent / 100);
$igst = $total * ($igst_percent / 100);

fputcsv($file, [
  $row['invoice_no'], 
  $row['invoice_date'],  
  $row['Customer_Name'], 
  $row['Customer_Mobile'],
  $row['Product_Name'], 
  $row['HSN'], 
  $row['qty'], 
  $row['Selling_price'], 
  $sgst,         
  $sgst_percent, 
  $cgst,         
  $cgst_percent, 
  $igst,         
  $igst_percent, 
  '0.0',         
  '0.0',         
  $total
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/GST_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(600, 670));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
  'Invoice Id', 
 'Invoice Date', 
 'Customer Name', 
 'Customer Mobile', 
 'Item Name', 
 'HSN', 
 'Quantity', 
 'Price Per Unit', 
 'SGST', 
 'SGST%', 
 'CGST', 
 'CGST%', 
 'IGST', 
 'IGST%', 
 'CESS', 
 'CESS%', 
 'Item Total'
];

// Set column widths
$colWidths = array_fill(0, count($headers), 38); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
    $total=$row['Selling_price']*$row['qty'];
$sgst_percent = 2.5;
$cgst_percent = 2.5;
$igst_percent = 5.0;
$sgst = $total * ($sgst_percent / 100);
$cgst = $total * ($cgst_percent / 100);
$igst = $total * ($igst_percent / 100);
$values = [
    $row['invoice_no'], 
    $row['invoice_date'],  
    $row['Customer_Name'], 
    $row['Customer_Mobile'],
    $row['Product_Name'], 
    $row['HSN'], 
    $row['qty'], 
    $row['Selling_price'], 
    $sgst,         
    $sgst_percent, 
    $cgst,         
    $cgst_percent, 
    $igst,         
    $igst_percent, 
    '0.0',         
    '0.0',         
    $total
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "invetory Report") {  
    $query = "SELECT 
    p.Product_id,
    p.Product_name,
    p.MRP,
    p.HSN,
    p.qty,
    p.SKU,
    p.Selling_price,
    p.date
 
FROM 
    product p
WHERE 
    p.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND p.date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND p.date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(p.date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND p.date BETWEEN '$startDate' AND '$endDate'";
}



// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
while ($row = $result->fetch_assoc()) {
$data[] = $row;
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/inventory_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
    'Item Sku',
    'Item Name',
    'Quantity',
    'Lowest MRP',
    'Highest MRP',
    'Lowest Sale Price',
    'Highest Sale Price',
    'Live Sale Price',
    'Live Inventory Value'
];



fputcsv($file, $header);

// Write data rows
foreach ($data as $row) {


fputcsv($file, [
  $row['SKU'], 
  $row['Product_name'],  
  $row['qty'], 
  $row['MRP'],
  $row['MRP'],
  $row['Selling_price'],
  $row['Selling_price'],
  $row['Selling_price'],
  $row['qty']
 
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/inventory_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(400, 300));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
  'Item Sku',
    'Item Name',
    'Quantity',
    'Lowest MRP',
    'Highest MRP',
    'Lowest Sale Price',
    'Highest Sale Price',
    'Live Sale Price',
    'Live Inventory Value'
];

// Set column widths
$colWidths = array_fill(0, count($headers), 42); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {

$values = [
    $row['SKU'], 
    $row['Product_name'],  
    $row['qty'], 
    $row['MRP'],
    $row['MRP'],
    $row['Selling_price'],
    $row['Selling_price'],
    $row['Selling_price'],
    $row['qty'] 
 
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}

elseif($reportType == "order summary Report") {  
    $query = "SELECT 
  i.invoice_id, 
  i.invoice_no,  
  i.user_id, 
  i.created_date AS invoice_date, 
  i.Grand_total,
  i.Total_price,
  i.Total_discount,
  i.Tax,
  i.Roundoff,
  i.Balance,
  i.Shipping,
  i.Discount,
  i.Coupon_code,
  i.Coupon_amount
FROM 
   invoice i

WHERE 
  i.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
$query .= " AND i.created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
$query .= " AND i.created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
$query .= " AND YEAR(i.created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
$query .= " AND i.created_date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
while ($row = $result->fetch_assoc()) {
$data[] = $row;
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/order_summary_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
    'Date',
    'Type',
    'Sale Price',
    'Packaging Fee',
    'Delivery Fee',
    'Payment Charge',
    'Payment Discount',
    'Discount',
    'Round Discount',
    'Coupon Discount',
    'Total'
];

fputcsv($file, $header);

// Write data rows
foreach ($data as $row) {
// Ensure values are properly aligned to headers
fputcsv($file, [
  $row['invoice_date'],  
  '', 
  $row['Total_price'],
  '',
  '',
  '', 
  '', 
  $row['Discount'], 
  $row['Roundoff'], 
  $row['Coupon_amount'], 
  $row['Grand_total'] 
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/order_summary_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(440, 300));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Date',
    'Type',
    'Sale Price',
    'Packaging Fee',
    'Delivery Fee',
    'Payment Charge',
    'Payment Discount',
    'Discount',
    'Round Discount',
    'Coupon Discount',
    'Total'
];

// Set column widths
$colWidths = array_fill(0, count($headers), 38); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
$values = [
    $row['invoice_date'],  
    'invoice', 
    $row['Total_price'],
    '',
    '',
    '', 
    '', 
    $row['Discount'], 
    $row['Roundoff'], 
    $row['Coupon_amount'], 
    $row['Grand_total'] 
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "order and order item Report") {  
    $query = "SELECT 
    o.Order_id,
    o.order_no,
    o.Created_date AS order_date,
    o.Balance AS due_amount,
    o.Tax AS oTax,
    o.Grand_total AS oGrand_total,  
    o.Action_status AS oAction_status, 
    o.Store_status AS oStore_status,
    o.Created_id AS oCreated_id,   
    o.Editor_id AS oEditor_id, 
    o.Deliveryby,
    o.Tracking_id,
    o.Delivery_partner,      
    i.*,                
    od.*,
    od.Tax AS iTax,               
    pd.Product_name,
    pd.SKU,
    pd.HSN,
    pd.MRP,
    pd.Selling_price AS iSelling_price,
    pd.Tax, 
    pd.qty AS iQty,               
    p.*,                
    u.*                  
FROM 
orders o
LEFT JOIN 
invoice i 
ON 
o.Invoice_id = i.invoice_id
LEFT JOIN
order_data od
ON
o.Order_id = od.Order_id
LEFT JOIN 
product pd
ON
od.Product_id = pd.Product_id
LEFT JOIN 
payment p 
ON 
o.Order_id = p.Order_id
LEFT JOIN 
user_profile u
ON 
o.User_id = u.User_id 
WHERE 
o.Delete_status = 0
AND p.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(o.Created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
    $filePath = 'reports/order_order_item_report_' . time() . '.csv';
    $file = fopen($filePath, 'w');

    // Write the header row
    $header = [
        'Order Id', 
        'Order Date', 
        'Order Status', 
        'Type', 
        'Invoice Id', 
        'Invoice Date', 
        'Customer Name', 
        'Customer Mobile',
        'Cancel Reason', 
        'Sale Price', 
        'Shipping Charge', 
        'Payment Charge', 
        'Packaging Charge', 
        'Coupon Discount',
        'Coupon Code', 
        'Round Off',
        'Discount', 
        'Payment Discount', 
        'Tax Amount', 
        'Earn Points', 
        'Redeem Points', 
        'Due Amount', 
        'Total Amount', 
        'Delivery Mode', 
        'Payment Mode', 
        'Express Delivery', 
        'Delivery Slot', 
        'Delivery Start At', 
        'Delivery End At',
        'Delivery Tracking Id', 
        'Contact Name', 
        'Contact Mobile', 
        'Street1', 
        'Street2', 
        'City', 
        'State',
        'Pincode', 
        'UTM Id', 
        'UTM Campaign', 
        'Delivery Partner Name', 
        'Delivery Name', 
        'Item Name', 
        'Item Sku', 
        'Item Price', 
        'Item Qty', 
        'HSN', 
        'State', 
        'State Code', 
        'SGST', 
        'SGST%', 
        'CGST', 
        'CGST%', 
        'IGST', 
        'IGST%', 
        'CESS', 
        'CESS%', 
        'Item Tax', 
        'Item Total', 
        'Created By', 
        'Modified By'
    ];

    fputcsv($file, $header);

    // Write data rows
    foreach ($data as $row) {
        switch ($row['Payment_type']) {
            case '1':
                $paymenttype = "Cash";
                $paymentmode = "Cash";
                break;
            case '2':
                $paymenttype = "Card";
                $paymentmode = "Card";
                break;
            case '3':
                $paymenttype = "UPI";
                $paymentmode = "Bank";
                break;
            case '4':
                $paymenttype = "Bank Transfer";
                $paymentmode = "Bank";
                break;
            case '5':
                $paymenttype = "Cheque";
                $paymentmode = "Cheque";
                break;
            default:
                $paymenttype = "N/A";
                $paymentmode = "N/A";
        }

        $statusMap = [
            "1" => "New",
            "2" => "Confirmed",
            "3" => "Dispatched",
            "4" => "Delivered",
            "5" => "Cancelled",
            "6" => "Completed"
        ];
        $label = $statusMap[$row['oAction_status']] ?? "Unknown";

        $statusMap1 = [
            "1" => "In-store",
            "2" => "Online"
        ];
        $label1 = $statusMap1[$row['oStore_status']] ?? "Unknown";

        $total = $row['iSelling_price'] * $row['iQty'];
        $sgst_percent = 2.5;
        $cgst_percent = 2.5;
        $igst_percent = 5.0;
        $sgst = $total * ($sgst_percent / 100);
        $cgst = $total * ($cgst_percent / 100);
        $igst = $total * ($igst_percent / 100);

        fputcsv($file, [
            $row['order_no'],              
            $row['order_date'], 
            $label,
            $label1,
            $row['invoice_no'],
            $row['Created_date'], 
            $row['Name'],
            $row['Phone'],
            '', 
            $row['iSelling_price'],            
            $row['Shipping'],              
            '0.0', 
            '0.0',                
            $row['Coupon_amount'],                
            $row['Coupon_code'],               
            $row['Roundoff'],              
            $row['Discount'],
            '0.0',            
            $row['oTax'], 
            '0',   
            '',
            $row['due_amount'],
            $row['oGrand_total'],
            $row['Delivery_partner'],
            $paymenttype,  
            '',
            '', 
            '',
            '',
            '',
            $row['Name'],
            $row['Phone'],
            $row['Address'],
            '',
            $row['City'],
            $row['State'],
            $row['Pincode'],                    
            '-',                   
            '-',        
            $row['Deliveryby'],               
            $row['Tracking_id'], 
            $row['Product_name'],
            $row['SKU'],
            $row['iSelling_price'],
            $row['iQty'],            
            $row['HSN'],
            $row['State'],
            '', 
            $sgst,
            $cgst,
            $igst,
            $sgst,
            $cgst,
            $igst, 
            '0.0',
            '0.0',
            $row['iTax'],
            $total,
            $row['oCreated_id'],
            $row['oEditor_id'] 
        ]);
    }

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/order_order_item_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(2720, 1200));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Order Id', 
    'Order Date', 
    'Order Status', 
    'Type', 
    'Invoice Id', 
    'Invoice Date', 
    'Customer Name', 
    'Customer Mobile',
    'Cancel Reason', 
    'Sale Price', 
    'Shipping Charge', 
    'Payment Charge', 
    'Packaging Charge', 
    'Coupon Discount',
    'Coupon Code', 
    'Round Off',
    'Discount', 
    'Payment Discount', 
    'Tax Amount', 
    'Earn Points', 
    'Redeem Points', 
    'Due Amount', 
    'Total Amount', 
    'Delivery Mode', 
    'Payment Mode', 
    'Express Delivery', 
    'Delivery Slot', 
    'Delivery Start At', 
    'Delivery End At',
    'Delivery Tracking Id', 
    'Contact Name', 
    'Contact Mobile', 
    'Street1', 
    'Street2', 
    'City', 
    'State',
    'Pincode', 
    'UTM Id', 
    'UTM Campaign', 
    'Delivery Partner Name', 
    'Delivery Name', 
    'Item Name', 
    'Item Sku', 
    'Item Price', 
    'Item Qty', 
    'HSN', 
    'State', 
    'State Code', 
    'SGST', 
    'SGST%', 
    'CGST', 
    'CGST%', 
    'IGST', 
    'IGST%', 
    'CESS', 
    'CESS%', 
    'Item Tax', 
    'Item Total', 
    'Created By', 
    'Modified By'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 45); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
    switch ($row['Payment_type']) {
        case '1':
            $paymenttype = "Cash";
            $paymentmode = "Cash";
            break;
        case '2':
            $paymenttype = "Card";
            $paymentmode = "Card";
            break;
        case '3':
            $paymenttype = "UPI";
            $paymentmode = "Bank";
            break;
        case '4':
            $paymenttype = "Bank Transfer";
            $paymentmode = "Bank";
            break;
        case '5':
            $paymenttype = "Cheque";
            $paymentmode = "Cheque";
            break;
        default:
            $paymenttype = "N/A";
            $paymentmode = "N/A";
    }

    $statusMap = [
        "1" => "New",
        "2" => "Confirmed",
        "3" => "Dispatched",
        "4" => "Delivered",
        "5" => "Cancelled",
        "6" => "Completed"
    ];
    $label = $statusMap[$row['oAction_status']] ?? "Unknown";

    $statusMap1 = [
        "1" => "In-store",
        "2" => "Online"
    ];
    $label1 = $statusMap1[$row['oStore_status']] ?? "Unknown";

    $total = $row['iSelling_price'] * $row['iQty'];
    $sgst_percent = 2.5;
    $cgst_percent = 2.5;
    $igst_percent = 5.0;
    $sgst = $total * ($sgst_percent / 100);
    $cgst = $total * ($cgst_percent / 100);
    $igst = $total * ($igst_percent / 100);
$values = [
    $row['order_no'],              
    $row['order_date'], 
    $label,
    $label1,
    $row['invoice_no'],
    $row['Created_date'], 
    $row['Name'],
    $row['Phone'],
    '', 
    $row['iSelling_price'],            
    $row['Shipping'],              
    '0.0', 
    '0.0',                
    $row['Coupon_amount'],                
    $row['Coupon_code'],               
    $row['Roundoff'],              
    $row['Discount'],
    '0.0',            
    $row['oTax'], 
    '0',   
    '',
    $row['due_amount'],
    $row['oGrand_total'],
    $row['Delivery_partner'],
    $paymenttype,  
    '',
    '', 
    '',
    '',
    '',
    $row['Name'],
    $row['Phone'],
    $row['Address'],
    '',
    $row['City'],
    $row['State'],
    $row['Pincode'],                    
    '-',                   
    '-',        
    $row['Deliveryby'],               
    $row['Tracking_id'], 
    $row['Product_name'],
    $row['SKU'],
    $row['iSelling_price'],
    $row['iQty'],            
    $row['HSN'],
    $row['State'],
    '', 
    $sgst,
    $cgst,
    $igst,
    $sgst,
    $cgst,
    $igst, 
    '0.0',
    '0.0',
    $row['iTax'],
    $total,
    $row['oCreated_id'],
    $row['oEditor_id']
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "abandonedcart Report") {  
    $query = "SELECT 
  c.Cart_id,
  c.User_id,
  c.Product_id,
  c.Category_id,
  c.Variant_id,
  c.Quantity,
  c.Created_Date,
  c.removed_date,
  u.Name,
  u.Phone,
  u.Address,
  u.City,
  u.State,
  u.Pincode,
  pd.Product_name,
  pd.SKU,
  pd.HSN,
  pd.Selling_price,
  pd.tax


FROM 
cart c 

LEFT JOIN 
product pd
ON
c.Product_id = pd.Product_id
LEFT JOIN 
user_profile u
ON 
c.User_id = u.User_id 
WHERE 
c.Delete_status = 1
AND u.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND c.removed_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND c.removed_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(c.removed_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND c.removed_date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
    $filePath = 'reports/abandonedcart_report_' . time() . '.csv';
    $file = fopen($filePath, 'w');

    // Write the header row
    $header = [
        'cart-id', 
        'cart_no',
        'create date', 
        'customer name', 
        'customer moblie', 
        'delivery mode',
        'pick up name', 
        'pick up moblie', 
        'sub total', 
        'shipping charge', 
        'packaging charge',
        'payment charge', 
        'coupon code', 
        'coupon discount', 
        'payment discount', 
        'tax amount',
        'total amount', 
        'UTM ID', 
        'UTM campaign', 
        'Name', 
        'mobile',
        'Address',
        'city', 
        'state', 
        'pincode', 
        'SKU', 
        'Item name',
        'Item qty',
        'Item price'
    ];

    fputcsv($file, $header);

    // Write data rows
    foreach ($data as $row) {
        

        $total = $row['Selling_price'] * $row['Quantity'];

        fputcsv($file, [
            $row['cart_no'],              
            $row['Created_Date'], 
            $row['Name'],
            $row['Phone'],
            '',
            '',
            '',
            $total,
            '0.0',
            '0.0',                        
            '0.0', 
            '0.0', 
            '0.0',               
           '0.0',     
           $row['tax'],  
           $total,
           '-',
           '-',
           $row['Name'],
           $row['Phone'],
           $row['Address'],
           $row['City'],
           $row['State'],
           $row['Pincode'],
           $row['SKU'],
           $row['Product_name'],
           $row['Quantity'], 
           $row['Selling_price']        
          
        ]);
    }

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/adanbordedcart_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(1280, 700));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'cart-id', 
    'create date', 
    'customer name', 
    'customer moblie', 
    'delivery mode',
    'pick up name', 
    'pick up moblie', 
    'sub total', 
    'shipping charge', 
    'packaging charge',
    'payment charge', 
    'coupon code', 
    'coupon discount', 
    'payment discount', 
    'tax amount',
    'total amount', 
    'UTM ID', 
    'UTM campaign', 
    'Name', 
    'mobile',
    'Address',
    'city', 
    'state', 
    'pincode', 
    'SKU', 
    'Item name',
    'Item qty',
    'Item price'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 45); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
    $total = $row['Selling_price'] * $row['Quantity'];
$values = [
            $row['cart_no'],              
            $row['Created_Date'], 
            $row['Name'],
            $row['Phone'],
            '',
            '',
            '',
            $total,
            '0.0',
            '0.0',                        
            '0.0', 
            '0.0', 
            '0.0',               
           '0.0',     
           $row['tax'],  
           $total,
           '-',
           '-',
           $row['Name'],
           $row['Phone'],
           $row['Address'],
           $row['City'],
           $row['State'],
           $row['Pincode'],
           $row['SKU'],
           $row['Product_name'],
           $row['Quantity'], 
           $row['Selling_price']        
          
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}

elseif($reportType == "wishlist Report") {  
    $query = "SELECT 
  w.wishlist_no,
  w.User_id,
  w.Product_id,
  w.date,
  w.removed_date,
  u.Name,
  u.Phone,
  u.Address,
  u.City,
  u.State,
  u.Pincode,
  pd.Product_name,
  pd.SKU,
  pd.HSN,
  pd.Selling_price,
  pd.tax


FROM 
wish_list w

LEFT JOIN 
product pd
ON
w.Product_id = pd.Product_id
LEFT JOIN 
user_profile u
ON 
w.User_id = u.User_id 
WHERE 
w.Delete_status = 0
AND u.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND w.date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND w.date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(w.date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND w.date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
    $filePath = 'reports/wishlist_report_' . time() . '.csv';
    $file = fopen($filePath, 'w');

    // Write the header row
    $header = [
        'Wishlist-id', 
        'create date', 
        'customer name', 
        'customer moblie', 
        'delivery mode',
        'pick up name', 
        'pick up moblie', 
        'shipping charge', 
        'packaging charge',
        'payment charge', 
        'coupon code', 
        'coupon discount', 
        'payment discount', 
        'tax amount', 
        'UTM ID', 
        'UTM campaign', 
        'Name', 
        'mobile',
        'Address',
        'city', 
        'state', 
        'pincode', 
        'SKU', 
        'Item name',
        'Item price'
    ];

    fputcsv($file, $header);

    // Write data rows
    foreach ($data as $row) {
        


        fputcsv($file, [
            $row['wishlist_no'],              
            $row['date'], 
            $row['Name'],
            $row['Phone'],
            '',
            '',
            '',
            '0.0',
            '0.0',                        
            '0.0', 
            '0.0', 
            '0.0',               
           '0.0',     
           $row['tax'], 
           '-',
           '-',
           $row['Name'],
           $row['Phone'],
           $row['Address'],
           $row['City'],
           $row['State'],
           $row['Pincode'],
           $row['SKU'],
           $row['Product_name'],
           $row['Selling_price']        
          
        ]);
    }

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/wishlist_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(1150, 700));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
    'Wishlist-id', 
    'create date', 
    'customer name', 
    'customer moblie', 
    'delivery mode',
    'pick up name', 
    'pick up moblie', 
    'shipping charge', 
    'packaging charge',
    'payment charge', 
    'coupon code', 
    'coupon discount', 
    'payment discount', 
    'tax amount', 
    'UTM ID', 
    'UTM campaign', 
    'Name', 
    'mobile',
    'Address',
    'city', 
    'state', 
    'pincode', 
    'SKU', 
    'Item name',
    'Item price'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 45); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {
$values = [
    $row['wishlist_no'],              
    $row['date'], 
    $row['Name'],
    $row['Phone'],
    '',
    '',
    '',
    '0.0',
    '0.0',                        
    '0.0', 
    '0.0', 
    '0.0',               
   '0.0',     
   $row['tax'], 
   '-',
   '-',
   $row['Name'],
   $row['Phone'],
   $row['Address'],
   $row['City'],
   $row['State'],
   $row['Pincode'],
   $row['SKU'],
   $row['Product_name'],
   $row['Selling_price']        
          
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}
elseif($reportType == "whatsappbot Report") {  
    $query = "SELECT 
        o.Order_id,
        o.order_no,
        o.Delivery_partner,
        o.Tracking_id,
        i.invoice_id,
        i.invoice_no,
        i.created_date,
        u.Name AS customer_name,
        u.Phone AS customer_mobile
  
FROM 
    orders o
LEFT JOIN 
    invoice i 
ON 
    o.Invoice_id = i.invoice_id
LEFT JOIN 
    user_profile u
ON 
    o.User_id = u.User_id 
WHERE 
    o.Delete_status = 0
    AND u.Delete_status = 0";

// Apply duration filters (last week, last month, etc.)
if ($duration == "Last Week") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 WEEK";
} elseif ($duration == "Last Month") {
    $query .= " AND o.Created_date >= NOW() - INTERVAL 1 MONTH";
} elseif ($duration == "This Year") {
    $query .= " AND YEAR(o.Created_date) = YEAR(NOW())";
} elseif ($duration == "Custom" && $startDate && $endDate) {
    $query .= " AND o.Created_date BETWEEN '$startDate' AND '$endDate'";
}

// Perform the query using MySQLi
$result = $conn->query($query);
$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

// Generate the CSV file
if ($reportFormat == "Xlsx") {
$filePath = 'reports/whatsappbot_report_' . time() . '.csv';
$file = fopen($filePath, 'w');

// Write the header row
$header = [
    'Number', 
    'Order No', 
    'Invoice No',
    'Customer Name', 
    'Delivery Partner Name', 
    'Tracking ID'
];


fputcsv($file, $header);

 

// Write data rows
foreach ($data as $row) {
    
fputcsv($file, [
    $row['customer_mobile'],               
    $row['order_no'],                 
    $row['invoice_no'],               
    $row['customer_name'],                
    $row['Delivery_partner'],               
    $row['Tracking_id']
]);
}

fclose($file);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
          VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $filePath]);
} elseif ($reportFormat == "pdf") {
$filePath = 'reports/whatsapbot_report_' . time() . '.pdf';

// Create a new PDF document
$pdf = new FPDF('L', 'mm', array(250, 320));

$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Table headers
$headers = [
  'Number', 
    'Order No', 
    'Invoice No',
    'Customer Name', 
    'Delivery Partner Name', 
    'Tracking ID'
];


// Set column widths
$colWidths = array_fill(0, count($headers), 50); // Adjust column widths as needed
$rowHeight = 8;

// Print header row
foreach ($headers as $index => $header) {
$pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row

// Print data rows
foreach ($data as $row) {

$values = [
    $row['customer_mobile'],               
    $row['order_no'],                 
    $row['invoice_no'],               
    $row['customer_name'],                
    $row['Delivery_partner'],               
    $row['Tracking_id'] 
];

foreach ($values as $index => $value) {
  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
}
$pdf->Ln(); // Move to the next row
}

// Save the PDF file
$pdf->Output('F', $filePath);

$report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
$report_no_result = mysqli_query($conn, $report_no_query);
$max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
$reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
$durationText = $duration ?? 'N/A';
$insertQuery = "INSERT INTO reports (Report_no, date, Duration, Excel_path, Delete_status) 
         VALUES ('$reportNo', NOW(), '$durationText', '$filePath', 0)";
$conn->query($insertQuery);

echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $filePath]);
} else {
echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
}

}

}
}
?>
