<?php
// Get the raw POST data
$data = json_decode(file_get_contents('php://input'), true);

// Check if the data is valid
if (isset($data['barcodeImage']) && isset($data['barcodeImagePath'])) {
    $barcodeImage = $data['barcodeImage'];
    $barcodeImagePath = $data['barcodeImagePath'];

    // Decode the base64-encoded image data
    $imageData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $barcodeImage));

    // Save the image to the specified path under 'barcodes' folder
    $savePath = $_SERVER['DOCUMENT_ROOT'] . '/' . $barcodeImagePath;

    if (file_put_contents($savePath, $imageData)) {
        // Return success response with the full URL of the saved image
        $imageUrl = 'https://hapitest.xyz/hapi%20commers/api/' . $barcodeImagePath;
        echo json_encode([
            'status' => 'success',
            'message' => 'Barcode saved successfully.',
            'imageUrl' => $imageUrl
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to save barcode image.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid data received.']);
}
?>
