<?php
// db.php for database conn
require_once 'db.php';

// Get the input data from the request
$data = json_decode(file_get_contents('php://input'), true);
$productId = $data['productId'];
$newQuantity = $data['newQuantity'];

// Check if the required fields are present
if (!$productId || !$newQuantity) {
    echo json_encode(["error" => "Product ID and Quantity are required"]);
    exit;
}

// Update product table
$productQuery = "UPDATE product SET qty = $newQuantity WHERE Product_id = $productId";
$productUpdateSuccess = mysqli_query($conn, $productQuery);

// Update inventory table
$inventoryQuery = "UPDATE inventory SET Qty = $newQuantity, date_modified = NOW() WHERE Product_id = $productId";
$inventoryUpdateSuccess = mysqli_query($conn, $inventoryQuery);

// Check if both updates were successful
if ($productUpdateSuccess && $inventoryUpdateSuccess) {
    echo json_encode(["success" => "Quantity updated successfully"]);
} else {
    echo json_encode(["error" => "Failed to update quantity"]);
}

// Close the database conn
mysqli_close($conn);
?>
