<?php
header('Content-Type: application/json');

// Include your database connection
include 'db.php';

// Get the JSON input
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate input
if (!isset($data['product_id']) || empty($data['product_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Product ID is required']);
    exit;
}

$product_id = intval($data['product_id']);
$category_id = intval($data['category_id']); // Expecting 0

// Update query (not using prepared statements)
$query = "UPDATE product SET subcategory = $category_id WHERE Product_id = $product_id";

if (mysqli_query($conn, $query)) {
    echo json_encode(['status' => 'success', 'message' => 'Product unassigned successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to unassign product']);
}

// Close the database connection
mysqli_close($conn);
