<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST (should be PUT, but you're using POST here)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from the request (parsed from JSON body)
$inputData = json_decode(file_get_contents("php://input"), true);

// Retrieve data
$banner_id = $inputData['Banner_id'] ?? null; // Use Banner_id instead of Banner_seo_id
$seo_title = $inputData['Seo_title'] ?? null;
$seo_description = $inputData['Seo_description'] ?? null;
$delete_status = $inputData['Delete_status'] ?? 0; // Default Delete_status as 0 (not deleted)

// Validate required fields
if (!$banner_id || !$seo_title || !$seo_description) {
    echo json_encode(["status" => "error", "message" => "Banner ID, SEO Title, and SEO Description are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$banner_id = mysqli_real_escape_string($conn, $banner_id);
$seo_title = mysqli_real_escape_string($conn, $seo_title);
$seo_description = mysqli_real_escape_string($conn, $seo_description);
$delete_status = intval($delete_status);

// Query to update the banner_seo record by Banner_id
$query = "UPDATE banner_seo 
          SET Seo_title = '$seo_title', Seo_description = '$seo_description', Delete_status = $delete_status 
          WHERE Banner_id = '$banner_id'"; // Use Banner_id for update

// Execute the query and check for success
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Banner SEO record updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update Banner SEO record"]);
}
?>
