<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Read the raw POST data
    $rawData = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($rawData, true);

    // Check for errors in JSON decoding
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Check for required fields
    if (!isset($data['categoryid']) || !isset($data['mode'])) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
        exit();
    }

    $categoryId = $data['categoryid'];  // Category ID
    $mode = $data['mode'];  // Mode value (1 for Online, 0 for Offline)

    // Sanitize input
    $categoryId = $conn->real_escape_string($categoryId);
    $mode = $conn->real_escape_string($mode);

    // Update query to change the mode
    $sql = "UPDATE categories SET mode = '$mode' WHERE category_ID = '$categoryId'";

    if ($conn->query($sql) === TRUE) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Mode updated successfully'
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update mode', 'error_detail' => $conn->error]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
