<?php
header("Content-Type: application/json");

require 'db.php'; // Ensure this connects correctly to your database

// Read and decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

if (!$data) {
    echo json_encode(["status" => "error", "message" => "Invalid or missing JSON payload"]);
    exit;
}

// Sanitize input
$couponid = mysqli_real_escape_string($conn, $data['couponid']);
$couponcode = mysqli_real_escape_string($conn, $data['couponcode']);
$createddate = mysqli_real_escape_string($conn, $data['create_date']);
$expiryDate = mysqli_real_escape_string($conn, $data['expiry_date']);
$description = mysqli_real_escape_string($conn, $data['description']);
$usagepercustomer = mysqli_real_escape_string($conn, $data['usagepercustomer']);
$productid = mysqli_real_escape_string($conn, $data['productid']);
$customerid = mysqli_real_escape_string($conn, $data['customerid']);
$amount = mysqli_real_escape_string($conn, $data['amount']);
$percentage = mysqli_real_escape_string($conn, $data['percentage']);
$autoapply = mysqli_real_escape_string($conn, $data['autoapply']);
$minorderamount = mysqli_real_escape_string($conn, $data['minorderamount']);

// Update coupon table
$sql_coupon = "UPDATE coupon SET 
    coupon_code = '$couponcode',
    description = '$description',
    created_date = '$createddate',
    expiry_date = '$expiryDate',
    usage_per_customer = '$usagepercustomer',
    product_id = '$productid',
    customer_id = '$customerid',
    percentage = '$percentage',
    amount = '$amount',
    auto_apply = '$autoapply',
    min_order_amount = '$minorderamount'
WHERE id = '$couponid'";

if (mysqli_query($conn, $sql_coupon)) {
    echo json_encode(["status" => "success"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update coupon data", "error_detail" => mysqli_error($conn)]);
}

mysqli_close($conn);
?>
