<?php
include 'db.php'; // Adjust the path to your database connection file

header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

// Check if customerid is provided
if (empty($data['customerid'])) {
    echo json_encode(["success" => false, "error" => "customerid is missing"]);
    exit;
}

// Sanitize input data to prevent SQL injection
$displayname = mysqli_real_escape_string($connection, $data['displayname']);
$phoneno1 = mysqli_real_escape_string($connection, $data['phoneno1']);
$address = mysqli_real_escape_string($connection, $data['address']);
$pincode = mysqli_real_escape_string($connection, $data['pincode']);
$city = mysqli_real_escape_string($connection, $data['city']);
$state = mysqli_real_escape_string($connection, $data['state']);
$customer_id = mysqli_real_escape_string($connection, $data['customerid']);

// Update customer details
$update_query = "UPDATE customer 
                 SET displayname = '$displayname', phoneno = '$phoneno1', address = '$address', 
                     pincode = '$pincode', city = '$city', state = '$state' 
                 WHERE id = '$customer_id'";

// Insert into address table
$insert_query = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode) 
                 VALUES ('$customer_id', '$displayname', '$phoneno1', '$address', '$city', '$state', '$pincode')";

// Execute both queries and check results
if (mysqli_query($connection, $update_query) && mysqli_query($connection, $insert_query)) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => "Failed to update address: " . mysqli_error($connection)]);
}
?>
