<?php
include 'db.php';

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['estimate_id'] || $data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}
// Variables from input
$estimate_id = $data['estimate_id'];
$customerid = $data['customerid'];
$shipping = (float)$data['Shipping'];
$roundoff = (float)$data['Roundoff'];
$discount_percentage = (float)$data['Discount_percentage'];
$products = $data['Products'];

$grand_total = 0;
$tax_total = 0;
$discount_total = 0;
$product_total = 0;
$total_savings = 0;
$total_discount = 0;

// Fetch customer details
$user_query = "SELECT displayname FROM customer WHERE id = '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (mysqli_num_rows($user_result) > 0) {
    $user_data = mysqli_fetch_assoc($user_result);
    $displayname = $user_data['displayname'];
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

    // Fetch product details
       // Fetch product details
$product_query = "SELECT Product_name, MRP, qty, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
$product_result = mysqli_query($conn, $product_query);

if (mysqli_num_rows($product_result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => "Product ID $product_id not found or inactive."
    ]);
    exit;
}

$product_data = mysqli_fetch_assoc($product_result);
if ($product_data['qty'] < $qty) {
    echo json_encode([
        'status' => 'error',
        'message' => "Insufficient stock for Product ID $product_id."
    ]);
    exit;
}

$mrp = (float)$product_data['MRP'];
$sale_price_tax = (int)$product_data['sale_price_tax']; // Get sale price tax value (1 or 2)

// Calculate values
$discount = ($selling_price * $discount_percentage) / 100;
$product_subtotal = $selling_price * $qty;
$tax = 0;

if ($sale_price_tax == 2) {
    // Only calculate tax if sale_price_tax is 2
    $tax = ($product_subtotal * $tax_percentage) / 100;
}

$product_total += $product_subtotal;
$tax_total += $tax;
$discount_total += $discount * $qty;
$total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');



$estimate_update_query = "
    UPDATE estimate 
    SET 
        Tax = '$tax_total', 
        Discount = '$discount_total', 
        Discount_percentage = '$discount_percentage', 
        Shipping = '$shipping', 
        Roundoff = '$roundoff', 
        Total_saving = '$total_savings', 
        Total_price = '$product_total', 
        Grand_total = '$1'
    WHERE estimate_id = '$estimate_id'
";

if (!mysqli_query($conn, $estimate_update_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update estimate.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}




$estimate_data_update_query = "
UPDATE estimate_data 
SET Delete_status = 1
WHERE estimate_id = '$estimate_id'";
mysqli_query($conn, $estimate_data_update_query);


foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $product_query2 = "SELECT  MRP,  sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result2 = mysqli_query($conn, $product_query2);
    
    $product_data2 = mysqli_fetch_assoc($product_result2);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $MRP = (float)$product_data2['MRP'];
    $Sale_Price_Tax= $product_data2['sale_price_tax'];
    $discount_percentage1 = (float)$product['discount_Percentage'];
    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;

    $estimate_data_update_query = "
INSERT INTO estimate_data (
        estimate_id, 
        Product_id, 
        qty, 
        Selling_price, 
        MRP, 
        discount, 
        Discount_percentage, 
        Tax_percentage,
        salepricetax, 
        Tax, 
        Product_total
    ) VALUES (
        '$estimate_id', 
        '$product_id', 
        '$qty', 
        '$selling_price', 
        '$MRP', 
        '$discount', 
        '$discount_percentage1', 
        '$tax_percentage', 
        '$Sale_Price_Tax',
        '$tax', 
        '$product_subtotal'
    )
    ";

    if (!mysqli_query($conn, $estimate_data_update_query)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to update estimate data.',
            'error' => mysqli_error($conn)
        ]);
        exit;
    }
}

// Return success message
echo json_encode([
    'status' => 'success',
    'message' => 'estimate updated successfully.'
]);

?>
