<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve and validate the input
$testimonial_id = $_POST['testimonial_id'] ?? null;
$byname = $_POST['byname'] ?? null;
$title = $_POST['title'] ?? null;
$description = $_POST['description'] ?? null;
$position = $_POST['position'] ?? null;
$active = $_POST['active'] ?? null;

if (!$testimonial_id) {
    echo json_encode(["status" => "error", "message" => "Testimonial ID is required"]);
    exit;
}

// Initialize file paths
$imageDir = 'images/testimonial/';
$imagePath = null;

// Handle image upload
if (!empty($_FILES['image']['name'])) {
    $imagePath = $imageDir . basename($_FILES['image']['name']);
    if (!move_uploaded_file($_FILES['image']['tmp_name'], $imagePath)) {
        echo json_encode(["status" => "error", "message" => "Failed to upload image"]);
        exit;
    }
}

// Build the update query dynamically
$updateFields = [];

if ($byname !== null) {
    $updateFields[] = "byname = '" . mysqli_real_escape_string($conn, $byname) . "'";
}

if ($title !== null) {
    $updateFields[] = "Title = '" . mysqli_real_escape_string($conn, $title) . "'";
}

if ($description !== null) {
    $updateFields[] = "Description = '" . mysqli_real_escape_string($conn, $description) . "'";
}

if ($position !== null) {
    $updateFields[] = "position = " . intval($position);
}

if ($active !== null) {
    $updateFields[] = "active = " . intval($active);
}

if ($imagePath !== null) {
    $updateFields[] = "Image = '" . mysqli_real_escape_string($conn, $imagePath) . "'";
}

// Check if there are fields to update
if (empty($updateFields)) {
    echo json_encode(["status" => "error", "message" => "No data provided for update"]);
    exit;
}

// Create the query
$updateQuery = "UPDATE testimonial SET " . implode(", ", $updateFields) . " WHERE testimonial_id = '" . mysqli_real_escape_string($conn, $testimonial_id) . "'";

// Execute the update query
if (mysqli_query($conn, $updateQuery)) {
    echo json_encode(["status" => "success", "message" => "Testimonial updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update testimonial"]);
}
?>
