<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST (should be PUT, but you're using POST here)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from the request (parsed from JSON body)
$inputData = json_decode(file_get_contents("php://input"), true);

// Retrieve data
$testimonial_id = $inputData['testimonial_id'] ?? null; // Use testimonial_id instead of testimonial_seo_id
$seo_title = $inputData['Seo_title'] ?? null;
$seo_description = $inputData['Seo_description'] ?? null;
$delete_status = $inputData['Delete_status'] ?? 0; // Default Delete_status as 0 (not deleted)

// Validate required fields
if (!$testimonial_id || !$seo_title || !$seo_description) {
    echo json_encode(["status" => "error", "message" => "testimonial ID, SEO Title, and SEO Description are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$testimonial_id = mysqli_real_escape_string($conn, $testimonial_id);
$seo_title = mysqli_real_escape_string($conn, $seo_title);
$seo_description = mysqli_real_escape_string($conn, $seo_description);
$delete_status = intval($delete_status);

// Query to update the testimonial_seo record by testimonial_id
$query = "UPDATE testimonial_seo 
          SET Seo_title = '$seo_title', Seo_description = '$seo_description', Delete_status = $delete_status 
          WHERE Testimonial_id = '$testimonial_id'"; // Use testimonial_id for update

// Execute the query and check for success
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "testimonial SEO record updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update testimonial SEO record"]);
}
?>
