<?php
// Include the database connection file
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Parse JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Check if user is logged in
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
        exit();
    }
    $user_id = $_SESSION['user_id'];

    // Validate required fields
    $requiredFields = ['name', 'email', 'phone', 'street1', 'city', 'pincode'];
    foreach ($requiredFields as $field) {
        if (empty($input[$field])) {
            echo json_encode(['status' => 'error', 'message' => "$field is required"]);
            exit();
        }
    }

    // Sanitize input
    $name = mysqli_real_escape_string($conn, $input['name']);
    $email = mysqli_real_escape_string($conn, $input['email']);
    $phone = mysqli_real_escape_string($conn, $input['phone']);
    $address = mysqli_real_escape_string($conn, $input['street1']);
    $street2 = isset($input['street2']) ? mysqli_real_escape_string($conn, $input['street2']) : '';
    $city = mysqli_real_escape_string($conn, $input['city']);
    $pincode = mysqli_real_escape_string($conn, $input['pincode']);
    $storename = isset($input['storename']) ? mysqli_real_escape_string($conn, $input['storename']) : '';
    $ifsc = isset($input['ifsc']) ? mysqli_real_escape_string($conn, $input['ifsc']) : '';
    $acountno = isset($input['acountno']) ? mysqli_real_escape_string($conn, $input['acountno']) : '';
    $bankname = isset($input['bankname']) ? mysqli_real_escape_string($conn, $input['bankname']) : '';
    $actype = isset($input['actype']) ? mysqli_real_escape_string($conn, $input['actype']) : '';
    $upiid = isset($input['upiid']) ? mysqli_real_escape_string($conn, $input['upiid']) : '';
    $fburl = isset($input['fburl']) ? mysqli_real_escape_string($conn, $input['fburl']) : '';
    $twurl = isset($input['twurl']) ? mysqli_real_escape_string($conn, $input['twurl']) : '';
    $liurl = isset($input['liurl']) ? mysqli_real_escape_string($conn, $input['liurl']) : '';
    $insurl = isset($input['insurl']) ? mysqli_real_escape_string($conn, $input['insurl']) : '';
    $youurl = isset($input['youurl']) ? mysqli_real_escape_string($conn, $input['youurl']) : '';

    // Begin transaction to ensure both updates are successful
    $store_image = null;
    if (isset($_FILES['store_image']) && $_FILES['store_image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'images/';
        $fileName = basename($_FILES['store_image']['name']);
        $targetFilePath = $uploadDir . $fileName;
    
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
    
        if (move_uploaded_file($_FILES['store_image']['tmp_name'], $targetFilePath)) {
            $store_image = $targetFilePath;
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to upload image']);
            exit();
        }
    }

    $conn->begin_transaction();

    try {
        // Update user_profile table
        $updateProfileSql = "UPDATE user_profile 
SET 
    acount_name = '$name', 
    Email = '$email', 
    Phone = '$phone', 
    Address = '$address', 
    street2 = '$street2', 
    City = '$city', 
    State = '$state', 
    Pincode = '$pincode',
    store_name = '$storename', 
    ifsc = '$ifsc', 
    acount_no = '$acountno',  
    bank_name = '$bankname', 
    acount_type = '$actype', 
    upiid = '$upiid',
    fburl = '$fburl', 
    twurl = '$twurl', 
    liurl = '$liurl', 
    insurl = '$insurl',
    youurl = '$youurl'
WHERE User_id = '$user_id';";

        if ($conn->query($updateProfileSql) === FALSE) {
            throw new Exception("Error updating user_profile");
        }

        // Update user_login table
        $updateLoginSql = "UPDATE user_login 
                           SET Name = '$name', Email = '$email', Phone = '$phone'
                           WHERE Delete_status = '0' AND Id = '$user_id';";

        if ($conn->query($updateLoginSql) === FALSE) {
            throw new Exception("Error updating user_login");
        }

        // Commit the transaction
        $conn->commit();

        // Send success response
        echo json_encode(['status' => 'success', 'message' => 'User information updated successfully']);
    } catch (Exception $e) {
        // Rollback the transaction if any query fails
        $conn->rollback();

        // Send error response
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    // Method not allowed
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

// Close the database connection
$conn->close();
?>
