<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from the request body
$data = json_decode(file_get_contents("php://input"), true);

// Extract input data
$wishlist_id = $data['wishlist_id'] ?? null;
$product_id = $data['product_id'] ?? null;
$product_name = $data['product_name'] ?? null;

// Validate required fields
if (!$wishlist_id || !$product_id || !$product_name) {
    echo json_encode(["status" => "error", "message" => "Wishlist ID, Product ID, and Product Name are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$wishlist_id = intval($wishlist_id);
$product_id = intval($product_id);
$product_name = mysqli_real_escape_string($conn, $product_name);

// Update query to update the wish list item
$query = "UPDATE wish_list 
          SET product_id = $product_id, product_name = '$product_name'         
          WHERE wishlist_id = $wishlist_id";

// Execute the query and check for success
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Wish list item updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update wish list item"]);
}
?>
