  // Function to load the index.html content into the div
  async function loadIndexContent() {
    try {
      // Fetch the index.html content
      const response = await fetch('home.html');
      if (!response.ok) throw new Error('Network response was not ok');
      
      // Get the text content
      const content = await response.text();
      
      // Insert the content into the placeholder div
      document.getElementById('index-content').innerHTML = content;
    } catch (error) {
      console.error('Failed to load index.html:', error);
    }
  }

  // Call the function to load the content
  loadIndexContent();